"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillProperties = exports.ECharts = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var echarts_1 = require("echarts");
var OPTION_PARAM = "option";
var DATASET_PARAM = "dataSet";
var INIT_OPTIONS = {
    tooltip: {},
    xAxis: { type: "category" },
    yAxis: {},
    series: [],
};
function ECharts(props) {
    var container = (0, react_1.useRef)(null);
    var _a = __read((0, react_1.useState)(), 2), chart = _a[0], setChart = _a[1];
    (0, react_1.useEffect)(function () {
        if (container.current && !chart) {
            var _chart = (0, echarts_1.init)(container.current, props.theme);
            _chart.setOption(INIT_OPTIONS);
            _chart.theme = props.theme;
            setChart(_chart);
        }
    }, [chart, props]);
    window.onresize = (0, react_1.useCallback)(function () {
        if (chart)
            chart.resize();
    }, [chart]);
    (0, react_1.useEffect)(function () {
        var _a, _b;
        if (!chart) {
            return;
        }
        if (chart.theme != props.theme) {
            chart.dispose();
            setChart(undefined);
        }
        else {
            console.log(props);
            var option = props.option || {};
            if (props.params) {
                props.params.delete(DATASET_PARAM);
                option = (0, exports.fillProperties)(props.params, option);
            }
            var nColumns = ((_b = (_a = option.dataset) === null || _a === void 0 ? void 0 : _a.source[0]) === null || _b === void 0 ? void 0 : _b.length) || 0;
            if (option.series && !option.series.length && nColumns > 1) {
                var series = Array(nColumns - 1).fill(option.series);
                option.series = series;
            }
            chart.setOption(option);
        }
    }, [props, chart]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (0, jsx_runtime_1.jsx)("div", { style: { width: "100%", height: "100%" }, ref: container }) }));
}
exports.ECharts = ECharts;
var fillProperties = function (props, option) {
    if (!option) {
        option = {};
    }
    var optionStr = props.get(OPTION_PARAM);
    if (optionStr) {
        try {
            var parsedOption = JSON.parse(optionStr);
            option = __assign(__assign({}, option), parsedOption);
        }
        catch (e) {
            console.log("Not able to parse option property");
        }
        props.delete(OPTION_PARAM);
    }
    props.forEach(function (value, key) { return setPropertyOnObject(key, value, option); });
    return option;
};
exports.fillProperties = fillProperties;
var setPropertyOnObject = function (prop, value, obj) {
    if (!prop || !value) {
        return obj;
    }
    var props = prop.split(".");
    var parent = obj;
    for (var i = 0; i < props.length; i++) {
        var name_1 = props[i];
        if (i === props.length - 1) {
            parent[name_1] = value;
        }
        else {
            parent[name_1] = parent[name_1] || {};
            parent = parent[name_1];
        }
    }
    return obj;
};
//# sourceMappingURL=ECharts.js.map