"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInterpolatedConfigurationValue = exports.doInterpolation = exports.definitelyPosixPath = exports.configurationTokenKeys = void 0;
var path = require("path");
var vscode = require("vscode");
exports.configurationTokenKeys = {
    "${workspaceFolder}": "${workspaceFolder}",
    "${fileDirname}": "${fileDirname}",
    "${fileExtname}": "${fileExtname}",
    "${fileBasename}": "${fileBasename}",
    "${fileBasenameNoExtension}": "${fileBasenameNoExtension}",
};
var definitelyPosixPath = function (filePath) {
    var result = filePath;
    if (/^(\w:\\)/.test(filePath)) {
        result = "/".concat(filePath);
    }
    return result.split(path.sep).join(path.posix.sep);
};
exports.definitelyPosixPath = definitelyPosixPath;
function doInterpolation(tokens, value) {
    return Object.entries(tokens).reduce(function (result, _a) {
        var _b = __read(_a, 2), tokenName = _b[0], tokenValue = _b[1];
        return result.replaceAll(tokenName, tokenValue);
    }, value);
}
exports.doInterpolation = doInterpolation;
function getInterpolatedConfigurationValue(args) {
    var _a, _b;
    var parsedPath = path.posix.parse(args.currentFileAbsolutePosixPath);
    var workspace = ((_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length)
        ? vscode.workspace.workspaceFolders.find(function (workspace) {
            var relative = path.posix.relative(workspace.uri.path, args.currentFileAbsolutePosixPath);
            return relative && !relative.startsWith("..") && !path.isAbsolute(relative);
        })
        : undefined;
    var fileExtensionWithDot = parsedPath.base.substring(parsedPath.base.indexOf("."));
    var tokens = {
        "${workspaceFolder}": (_b = workspace === null || workspace === void 0 ? void 0 : workspace.uri.path) !== null && _b !== void 0 ? _b : parsedPath.dir,
        "${fileDirname}": parsedPath.dir,
        "${fileExtname}": fileExtensionWithDot,
        "${fileBasename}": parsedPath.base,
        "${fileBasenameNoExtension}": parsedPath.base.substring(0, parsedPath.base.indexOf(".")),
    };
    return doInterpolation(tokens, args.value);
}
exports.getInterpolatedConfigurationValue = getInterpolatedConfigurationValue;
//# sourceMappingURL=ConfigurationInterpolation.js.map