/// <reference types="react" />
import * as ReactTable from "react-table";
import { BeeTableHeaderVisibility, InsertRowColumnsDirection } from "../../api";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
export interface BeeTableColumnUpdate<R extends object> {
    typeRef: string | undefined;
    name: string;
    column: ReactTable.ColumnInstance<R>;
    columnIndex: number;
}
export interface BeeTableCellUpdate<R extends object> {
    value: string;
    column: ReactTable.ColumnInstance<R>;
    columnIndex: number;
    row: R;
    rowIndex: number;
}
export interface BeeTableHeaderProps<R extends object> {
    reactTableInstance: ReactTable.TableInstance<R>;
    editColumnLabel?: string | {
        [groupType: string]: string;
    };
    headerVisibility?: BeeTableHeaderVisibility;
    skipLastHeaderGroup: boolean;
    getColumnKey: (column: ReactTable.ColumnInstance<R>) => string;
    tableColumns: ReactTable.Column<R>[];
    onColumnUpdates?: (columnUpdates: BeeTableColumnUpdate<R>[]) => void;
    onHeaderClick?: (columnKey: string) => void;
    onHeaderKeyUp?: (columnKey: string) => void;
    isEditableHeader: boolean;
    onColumnAdded?: (args: {
        beforeIndex: number;
        groupType: string | undefined;
        columnsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    shouldRenderRowIndexColumn: boolean;
    shouldShowRowsInlineControls: boolean;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
    setActiveCellEditing: (isEditing: boolean) => void;
}
export declare function BeeTableHeader<R extends object>({ reactTableInstance, editColumnLabel, headerVisibility, skipLastHeaderGroup, getColumnKey, onColumnUpdates, isEditableHeader, onColumnAdded, onHeaderClick, onHeaderKeyUp, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, resizerStopBehavior, lastColumnMinWidth, setActiveCellEditing, }: BeeTableHeaderProps<R>): JSX.Element;
//# sourceMappingURL=BeeTableHeader.d.ts.map