const canvas = document.createElement("canvas");
export function getTextWidth(text, font) {
    const context = canvas.getContext("2d");
    context.font = font;
    const metrics = context.measureText(text);
    return Math.ceil(metrics.width);
}
function getCssStyle(element, prop) {
    return window.getComputedStyle(element, null).getPropertyValue(prop);
}
export function getCanvasFont(el) {
    const fontWeight = getCssStyle(el, "font-weight") || "normal";
    const fontSize = getCssStyle(el, "font-size") || "16px";
    const fontFamily = getCssStyle(el, "font-family") || "Times New Roman";
    return `${fontWeight} ${fontSize} ${fontFamily}`;
}
//# sourceMappingURL=WidthsToFitData.js.map