import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useImperativeHandle, useMemo, useState } from "react";
import { useResizerRef, useResizingWidthsDispatch } from "./ResizingWidthsContext";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH } from "./WidthConstants";
export const BeeTableResizableColumnsContext = React.createContext({});
export const BeeTableResizableColumnsDispatchContext = React.createContext({});
export const BeeTableResizableColumnsContextProvider = ({ children, onChange, resizingRef, }) => {
    const refs = React.useRef(new Map());
    const [columnResizingWidths, setColumnResizingWidths] = useState(new Map());
    const onColumnResizingWidthChange = useCallback((args) => {
        setColumnResizingWidths((prev) => {
            const n = new Map(prev);
            for (const [columnIndex, newResizingWidth] of args.entries()) {
                if (newResizingWidth) {
                    n.set(columnIndex, newResizingWidth);
                }
            }
            return n;
        });
    }, []);
    const value = useMemo(() => {
        return { columnResizingWidths };
    }, [columnResizingWidths]);
    const dispatch = useMemo(() => {
        return {
            updateColumnResizingWidths: (newColumnResizingWidths) => {
                var _a, _b;
                for (const [columnIndex, newResizingWidth] of newColumnResizingWidths.entries()) {
                    for (const ref of (_a = refs.current.get(columnIndex)) !== null && _a !== void 0 ? _a : []) {
                        (_b = ref.setResizingWidth) === null || _b === void 0 ? void 0 : _b.call(ref, newResizingWidth);
                    }
                }
                onColumnResizingWidthChange(newColumnResizingWidths);
                onChange === null || onChange === void 0 ? void 0 : onChange(newColumnResizingWidths);
            },
            registerResizableCellRef: (columnIndex, ref) => {
                var _a, _b, _c;
                const prev = (_b = (_a = refs.current) === null || _a === void 0 ? void 0 : _a.get(columnIndex)) !== null && _b !== void 0 ? _b : new Set();
                (_c = refs.current) === null || _c === void 0 ? void 0 : _c.set(columnIndex, new Set([...prev, ref]));
                return ref;
            },
            deregisterResizableCellRef: (columnIndex, ref) => {
                var _a, _b;
                (_b = (_a = refs.current) === null || _a === void 0 ? void 0 : _a.get(columnIndex)) === null || _b === void 0 ? void 0 : _b.delete(ref);
            },
        };
    }, [onChange, onColumnResizingWidthChange]);
    useImperativeHandle(resizingRef, () => dispatch, [dispatch]);
    return (_jsx(BeeTableResizableColumnsContext.Provider, Object.assign({ value: value }, { children: _jsx(BeeTableResizableColumnsDispatchContext.Provider, Object.assign({ value: dispatch }, { children: _jsx(_Fragment, { children: children }) })) })));
};
export function useBeeTableResizableColumnsDispatch() {
    return React.useContext(BeeTableResizableColumnsDispatchContext);
}
export function useBeeTableResizableColumns() {
    return React.useContext(BeeTableResizableColumnsContext);
}
export function useBeeTableResizableCell(columnIndex, resizerStopBehavior, width, setWidth, initialResizingWidthValue) {
    const { registerResizableCellRef, deregisterResizableCellRef, updateColumnResizingWidths } = useBeeTableResizableColumnsDispatch();
    const initialResizingWidth = useMemo(() => {
        if (!initialResizingWidthValue) {
            return undefined;
        }
        return {
            value: initialResizingWidthValue,
            isPivoting: false,
        };
    }, [initialResizingWidthValue]);
    const [resizingWidth, setResizingWidth] = useState(initialResizingWidth);
    useResizerRef(useMemo(() => ({
        width,
        setWidth,
        resizingWidth,
        resizerStopBehavior,
    }), [resizerStopBehavior, resizingWidth, setWidth, width]));
    const _updateResizingWidth = useCallback((newResizingWidth) => {
        updateColumnResizingWidths(new Map([[columnIndex, newResizingWidth]]));
    }, [columnIndex, updateColumnResizingWidths]);
    useEffect(() => {
        const ref = registerResizableCellRef(columnIndex, { setResizingWidth });
        return () => {
            deregisterResizableCellRef(columnIndex, ref);
        };
    }, [columnIndex, setWidth, registerResizableCellRef, deregisterResizableCellRef]);
    useEffect(() => {
        updateColumnResizingWidths(new Map([[columnIndex, initialResizingWidth]]));
    }, [initialResizingWidth, columnIndex, initialResizingWidthValue, updateColumnResizingWidths]);
    return { resizingWidth, setResizingWidth: _updateResizingWidth };
}
export function usePublishedBeeTableResizableColumns(id, columnCount, hasRowIndexColumn) {
    const [columnResizingWidths, setColumnResizingWidths] = useState(new Map());
    const isPivoting = useMemo(() => {
        return [...columnResizingWidths.values()].some(({ isPivoting }) => isPivoting);
    }, [columnResizingWidths]);
    useEffect(() => {
        setColumnResizingWidths(hasRowIndexColumn
            ? new Map([[0, { isPivoting: false, value: BEE_TABLE_ROW_INDEX_COLUMN_WIDTH }]])
            : new Map());
    }, [columnCount, hasRowIndexColumn]);
    const onColumnResizingWidthChange = useCallback((args) => {
        setColumnResizingWidths((prev) => {
            const n = new Map(prev);
            for (const [columnIndex, newResizingWidth] of args.entries()) {
                if (newResizingWidth) {
                    n.set(columnIndex, newResizingWidth);
                }
            }
            return n;
        });
    }, []);
    const { updateResizingWidth } = useResizingWidthsDispatch();
    useEffect(() => {
        updateResizingWidth(id, (prev) => {
            return [...columnResizingWidths.values()].reduce((acc, resizingWidth) => ({
                value: acc.value + resizingWidth.value,
                isPivoting: acc.isPivoting || resizingWidth.isPivoting,
            }), {
                value: 0,
                isPivoting: false,
            });
        });
    }, [columnResizingWidths, id, updateResizingWidth]);
    return { onColumnResizingWidthChange, columnResizingWidths, isPivoting };
}
//# sourceMappingURL=BeeTableResizableColumnsContext.js.map