import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useMemo } from "react";
import { useRef, useState } from "react";
import "./BoxedExpressionEditorContext.css";
export const BoxedExpressionEditorContext = React.createContext({});
export const BoxedExpressionEditorDispatchContext = React.createContext({});
export function useBoxedExpressionEditor() {
    return useContext(BoxedExpressionEditorContext);
}
export function useBoxedExpressionEditorDispatch() {
    return useContext(BoxedExpressionEditorDispatchContext);
}
export function BoxedExpressionEditorContextProvider({ onExpressionChange, onWidthsChange, dataTypes, expressionHolderId, beeGwtService, children, pmmlDocuments, scrollableParentRef, onRequestFeelVariables, widthsById, hideDmn14BoxedExpressions, }) {
    const [currentlyOpenContextMenu, setCurrentlyOpenContextMenu] = useState(undefined);
    const editorRef = useRef(null);
    const widthsByIdRef = useRef(widthsById);
    React.useEffect(() => {
        widthsByIdRef.current = widthsById;
    }, [widthsById]);
    const dispatch = useMemo(() => ({
        setExpression: onExpressionChange,
        setWidthsById: (mutation) => {
            const newWidthsById = new Map(widthsByIdRef.current);
            widthsByIdRef.current = newWidthsById;
            mutation({ newMap: newWidthsById });
            onWidthsChange(newWidthsById);
        },
    }), [onExpressionChange, onWidthsChange]);
    return (_jsx(BoxedExpressionEditorContext.Provider, Object.assign({ value: {
            beeGwtService,
            editorRef,
            scrollableParentRef,
            expressionHolderId,
            dataTypes,
            pmmlDocuments,
            currentlyOpenContextMenu,
            setCurrentlyOpenContextMenu,
            onRequestFeelVariables,
            widthsById,
            hideDmn14BoxedExpressions,
        } }, { children: _jsx(BoxedExpressionEditorDispatchContext.Provider, Object.assign({ value: dispatch }, { children: _jsx("div", Object.assign({ className: "boxed-expression-provider", ref: editorRef }, { children: children })) })) })));
}
export function NestedExpressionDispatchContextProvider({ onSetExpression, children, }) {
    const { setWidthsById } = useBoxedExpressionEditorDispatch();
    const nestedExpressionDispatch = useMemo(() => {
        return {
            setExpression: (newExpressionAction) => {
                function getNewExpression(prev) {
                    return typeof newExpressionAction === "function" ? newExpressionAction(prev) : newExpressionAction;
                }
                onSetExpression({ getNewExpression });
            },
            setWidthsById,
        };
    }, [onSetExpression, setWidthsById]);
    return (_jsx(BoxedExpressionEditorDispatchContext.Provider, Object.assign({ value: nestedExpressionDispatch }, { children: children })));
}
//# sourceMappingURL=BoxedExpressionEditorContext.js.map