import * as React from "react";
import { BeeGwtService, DmnDataType, BoxedExpression, PmmlDocument } from "./api";
import { BoxedExpressionEditorProps, OnRequestFeelVariables } from "./BoxedExpressionEditor";
import "./BoxedExpressionEditorContext.css";
export interface BoxedExpressionEditorContextType {
    beeGwtService?: BeeGwtService;
    editorRef: React.RefObject<HTMLDivElement>;
    scrollableParentRef: React.RefObject<HTMLElement>;
    expressionHolderId: string;
    pmmlDocuments?: PmmlDocument[];
    dataTypes: DmnDataType[];
    currentlyOpenContextMenu: string | undefined;
    setCurrentlyOpenContextMenu: React.Dispatch<React.SetStateAction<string | undefined>>;
    onRequestFeelVariables?: OnRequestFeelVariables;
    widthsById: Map<string, number[]>;
    hideDmn14BoxedExpressions?: boolean;
}
export interface BoxedExpressionEditorDispatchContextType {
    setExpression: React.Dispatch<React.SetStateAction<BoxedExpression>>;
    setWidthsById: (mutation: ({ newMap }: {
        newMap: Map<string, number[]>;
    }) => void) => void;
}
export declare const BoxedExpressionEditorContext: React.Context<BoxedExpressionEditorContextType>;
export declare const BoxedExpressionEditorDispatchContext: React.Context<BoxedExpressionEditorDispatchContextType>;
export declare function useBoxedExpressionEditor(): BoxedExpressionEditorContextType;
export declare function useBoxedExpressionEditorDispatch(): BoxedExpressionEditorDispatchContextType;
export declare function BoxedExpressionEditorContextProvider({ onExpressionChange, onWidthsChange, dataTypes, expressionHolderId, beeGwtService, children, pmmlDocuments, scrollableParentRef, onRequestFeelVariables, widthsById, hideDmn14BoxedExpressions, }: React.PropsWithChildren<BoxedExpressionEditorProps>): JSX.Element;
export declare type OnSetExpression = (args: {
    getNewExpression: (prev: BoxedExpression | undefined) => BoxedExpression | undefined;
}) => void;
export declare function NestedExpressionDispatchContextProvider({ onSetExpression, children, }: React.PropsWithChildren<{
    onSetExpression: OnSetExpression;
}>): JSX.Element;
//# sourceMappingURL=BoxedExpressionEditorContext.d.ts.map