var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState } from "react";
import { Dropdown, DropdownItem, KebabToggle, DropdownPosition, DropdownToggle, DropdownToggleCheckbox, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Toolbar, ToolbarItem, ToolbarContent, ToolbarFilter, ToolbarToggleGroup, ToolbarGroup, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { OverflowMenu, OverflowMenuContent, OverflowMenuControl, OverflowMenuItem, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import { WorkflowInstanceState, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { BulkListType, } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { WorkflowInfoModal } from "@kie-tools/runtime-tools-components/dist/components/WorkflowInfoModal";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { formatForBulkListWorkflowInstance } from "../utils/WorkflowListUtils";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
var Category;
(function (Category) {
    Category["STATUS"] = "Status";
    Category["BUSINESS_KEY"] = "Business key";
})(Category || (Category = {}));
var BulkSelectionType;
(function (BulkSelectionType) {
    BulkSelectionType["NONE"] = "NONE";
    BulkSelectionType["PARENT"] = "PARENT";
    BulkSelectionType["PARENT_CHILD"] = "PARENT_CHILD";
})(BulkSelectionType || (BulkSelectionType = {}));
const WorkflowListToolbar = ({ filters, setFilters, applyFilter, refresh, workflowStates, setWorkflowStates, selectedInstances, setSelectedInstances, workflowInstances, setWorkflowInstances, isAllChecked, setIsAllChecked, driver, defaultStatusFilter, ouiaId, ouiaSafe, }) => {
    const [isExpanded, setIsExpanded] = useState(false);
    const [businessKeyInput, setBusinessKeyInput] = useState("");
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [operationType, setOperationType] = useState(undefined);
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [isCheckboxDropdownOpen, setisCheckboxDropdownOpen] = useState(false);
    const [operationResults, setOperationResults] = useState({
        ABORT: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        SKIP: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
        RETRY: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
    });
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const operations = {
        ABORT: {
            type: BulkListType.WORKFLOW,
            results: operationResults[OperationType.ABORT],
            messages: {
                successMessage: `Aborted workflows: `,
                noItemsMessage: `No workflows were aborted`,
                warningMessage: !workflowStates.includes(WorkflowInstanceState.Aborted)
                    ? `Note: The workflow status has been updated. The list may appear inconsistent until you refresh any applied filters.`
                    : "",
                ignoredMessage: `These workflows were ignored because they were already completed or aborted.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state === WorkflowInstanceState.Aborted ||
                            instance.state === WorkflowInstanceState.Completed) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleWorkflowMultipleAction(remainingInstances, OperationType.ABORT).then((result) => {
                        onShowMessage("Abort operation", result.successWorkflowInstances, result.failedWorkflowInstances, ignoredItems, OperationType.ABORT);
                        workflowInstances.forEach((instance) => {
                            result.successWorkflowInstances.forEach((successInstances) => {
                                if (successInstances.id === instance.id) {
                                    instance.state = WorkflowInstanceState.Aborted;
                                }
                            });
                        });
                        setWorkflowInstances([...workflowInstances]);
                    });
                }),
            },
        },
        SKIP: {
            type: BulkListType.WORKFLOW,
            results: operationResults[OperationType.SKIP],
            messages: {
                successMessage: `Skipped workflows: `,
                noItemsMessage: `No workflows were skipped`,
                ignoredMessage: `These workflows were ignored because they were not in error state.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance.state !== WorkflowInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleWorkflowMultipleAction(remainingInstances, OperationType.SKIP).then((result) => {
                        onShowMessage("Skip operation", result.successWorkflowInstances, result.failedWorkflowInstances, ignoredItems, OperationType.SKIP);
                    });
                }),
            },
        },
        RETRY: {
            type: BulkListType.WORKFLOW,
            results: operationResults[OperationType.RETRY],
            messages: {
                successMessage: `Retriggered workflows: `,
                noItemsMessage: `No workflows were retriggered`,
                ignoredMessage: `These workflows were ignored because they were not in error state.`,
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredItems = [];
                    const remainingInstances = selectedInstances.filter((instance) => {
                        if (instance["state"] !== WorkflowInstanceState.Error) {
                            ignoredItems.push(instance);
                        }
                        else {
                            return true;
                        }
                    });
                    yield driver.handleWorkflowMultipleAction(remainingInstances, OperationType.RETRY).then((result) => {
                        onShowMessage("Retry operation", result.successWorkflowInstances, result.failedWorkflowInstances, ignoredItems, OperationType.RETRY);
                    });
                }),
            },
        },
    };
    const onShowMessage = (title, successItems, failedItems, ignoredItems, operation) => {
        setModalTitle(title);
        setTitleType("success");
        setOperationType(operation);
        setOperationResults(Object.assign(Object.assign({}, operationResults), { [operation]: Object.assign(Object.assign({}, operationResults[operation]), { successItems: formatForBulkListWorkflowInstance(successItems), failedItems: formatForBulkListWorkflowInstance(failedItems), ignoredItems: formatForBulkListWorkflowInstance(ignoredItems) }) }));
        handleModalToggle();
    };
    const checkboxDropdownToggle = () => {
        setisCheckboxDropdownOpen(!isCheckboxDropdownOpen);
    };
    const onStatusToggle = (isExpandedItem) => {
        setIsExpanded(isExpandedItem);
    };
    const onWorkflowManagementButtonSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onWorkflowManagementKebabToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const onSelect = (event, selection) => {
        if (workflowStates.includes(selection)) {
            const newWorkflowStates = [...workflowStates].filter((state) => state !== selection);
            setWorkflowStates(newWorkflowStates);
        }
        else {
            setWorkflowStates([...workflowStates, selection]);
        }
    };
    const onDeleteChip = (categoryName, value) => {
        var _a;
        const clonedWorkflowStates = [...workflowStates];
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        switch (categoryName) {
            case Category.STATUS:
                _.remove(clonedWorkflowStates, (status) => {
                    return status === value;
                });
                setWorkflowStates(clonedWorkflowStates);
                setFilters(Object.assign(Object.assign({}, filters), { status: clonedWorkflowStates }));
                break;
            case Category.BUSINESS_KEY:
                _.remove(clonedBusinessKeyArray, (businessKey) => {
                    return businessKey === value;
                });
                setFilters(Object.assign(Object.assign({}, filters), { businessKey: clonedBusinessKeyArray }));
                break;
        }
        applyFilter({
            status: clonedWorkflowStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onApplyFilter = () => {
        var _a;
        setBusinessKeyInput("");
        const clonedBusinessKeyArray = [...((_a = filters.businessKey) !== null && _a !== void 0 ? _a : [])];
        if (businessKeyInput && !clonedBusinessKeyArray.includes(businessKeyInput)) {
            clonedBusinessKeyArray.push(businessKeyInput);
        }
        setFilters(Object.assign(Object.assign({}, filters), { status: workflowStates, businessKey: clonedBusinessKeyArray }));
        applyFilter({
            status: workflowStates,
            businessKey: clonedBusinessKeyArray,
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            businessKeyInput.length > 0 && onApplyFilter();
        }
    };
    const resetAllFilters = () => {
        const defaultFilters = {
            status: defaultStatusFilter,
            businessKey: [],
        };
        setWorkflowStates(defaultFilters.status);
        setFilters(defaultFilters);
        applyFilter(defaultFilters);
    };
    const resetSelected = () => {
        const clonedWorkflowInstances = _.cloneDeep(workflowInstances);
        clonedWorkflowInstances.forEach((workflowInstance) => {
            var _a;
            workflowInstance.isSelected = false;
            if (!_.isEmpty(workflowInstance.childWorkflowInstances)) {
                (_a = workflowInstance.childWorkflowInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    childInstance.isSelected = false;
                });
            }
        });
        setWorkflowInstances(clonedWorkflowInstances);
        setSelectedInstances([]);
        setIsAllChecked(false);
    };
    const handleCheckboxSelectClick = (selection, isCheckBoxClicked) => {
        const clonedWorkflowInstances = [...workflowInstances];
        if (selection === BulkSelectionType.NONE) {
            clonedWorkflowInstances.forEach((instance) => {
                instance.isSelected = false;
                instance.childWorkflowInstances &&
                    instance.childWorkflowInstances.length > 0 &&
                    instance.childWorkflowInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances([]);
        }
        if (selection === BulkSelectionType.PARENT) {
            const tempSelectedInstances = [];
            clonedWorkflowInstances.forEach((instance) => {
                var _a;
                if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                    instance.isSelected = true;
                    tempSelectedInstances.push(instance);
                }
                instance.childWorkflowInstances &&
                    instance.childWorkflowInstances.length > 0 &&
                    instance.childWorkflowInstances.forEach((childInstance) => {
                        childInstance.isSelected = false;
                    });
            });
            setSelectedInstances(tempSelectedInstances);
        }
        if (selection === BulkSelectionType.PARENT_CHILD) {
            const tempSelectedInstances = [];
            if (isAllChecked && isCheckBoxClicked) {
                tempSelectedInstances.length = 0;
                clonedWorkflowInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                        instance.isSelected = false;
                    }
                    instance.childWorkflowInstances &&
                        instance.childWorkflowInstances.length > 0 &&
                        instance.childWorkflowInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = false;
                                }
                            }
                        });
                });
            }
            else {
                clonedWorkflowInstances.forEach((instance) => {
                    var _a;
                    if (instance.serviceUrl && ((_a = instance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                        instance.isSelected = true;
                        tempSelectedInstances.push(instance);
                    }
                    instance.childWorkflowInstances &&
                        instance.childWorkflowInstances.length > 0 &&
                        instance.childWorkflowInstances.forEach((childInstance) => {
                            var _a;
                            if (childInstance.serviceUrl && ((_a = childInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                                if (instance.isOpen) {
                                    childInstance.isSelected = true;
                                    tempSelectedInstances.push(childInstance);
                                }
                            }
                        });
                });
            }
            setSelectedInstances(tempSelectedInstances);
        }
        setWorkflowInstances(clonedWorkflowInstances);
    };
    const statusMenuItems = [
        React.createElement(SelectOption, { key: "ACTIVE", value: "ACTIVE" }),
        React.createElement(SelectOption, { key: "COMPLETED", value: "COMPLETED" }),
        React.createElement(SelectOption, { key: "ERROR", value: "ERROR" }),
        React.createElement(SelectOption, { key: "ABORTED", value: "ABORTED" }),
        React.createElement(SelectOption, { key: "SUSPENDED", value: "SUSPENDED" }),
    ];
    const checkboxItems = [
        React.createElement(DropdownItem, { key: "none", onClick: () => handleCheckboxSelectClick(BulkSelectionType.NONE, false), id: "none" }, "Select none"),
        React.createElement(DropdownItem, { key: "all-parent", onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT, false), id: "all-parent" }, "Select all parent workflows"),
        React.createElement(DropdownItem, { key: "all-parent-child", onClick: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, false), id: "all-parent-child" }, "Select all workflows"),
    ];
    const dropdownItemsProcesManagementButtons = () => {
        return [
            React.createElement(DropdownItem, { key: "abort", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0 }, "Abort selected"),
            React.createElement(DropdownItem, { key: "skip", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0 }, "Skip selected"),
            React.createElement(DropdownItem, { key: "retry", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0 }, "Retry selected"),
        ];
    };
    const buttonItems = (React.createElement(OverflowMenu, { breakpoint: "xl" },
        React.createElement(OverflowMenuContent, null,
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.ABORT].functions.perform, isDisabled: selectedInstances.length === 0 }, "Abort selected")),
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.SKIP].functions.perform, isDisabled: selectedInstances.length === 0 }, "Skip selected")),
            React.createElement(OverflowMenuItem, null,
                React.createElement(Button, { variant: "secondary", onClick: operations[OperationType.RETRY].functions.perform, isDisabled: selectedInstances.length === 0 }, "Retry selected"))),
        React.createElement(OverflowMenuControl, null,
            React.createElement(Dropdown, { onSelect: onWorkflowManagementButtonSelect, toggle: React.createElement(KebabToggle, { onToggle: onWorkflowManagementKebabToggle }), isOpen: isKebabOpen, isPlain: true, dropdownItems: dropdownItemsProcesManagementButtons() }))));
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarItem, { variant: "bulk-select", id: "bulk-select" },
                React.createElement(Dropdown, { position: DropdownPosition.left, toggle: React.createElement(DropdownToggle, { isDisabled: filters.status.length === 0, onToggle: checkboxDropdownToggle, splitButtonItems: [
                            React.createElement(DropdownToggleCheckbox, { id: "select-all-checkbox", key: "split-checkbox", "aria-label": "Select all", isChecked: isAllChecked, onChange: () => handleCheckboxSelectClick(BulkSelectionType.PARENT_CHILD, true), isDisabled: filters.status.length === 0 }),
                        ] }, selectedInstances.length === 0 ? "" : selectedInstances.length + " selected"), dropdownItems: checkboxItems, isOpen: isCheckboxDropdownOpen })),
            React.createElement(ToolbarFilter, { chips: filters.status, deleteChip: onDeleteChip, className: "kogito-management-console__state-dropdown-list pf-u-mr-sm", categoryName: "Status", id: "datatoolbar-filter-status" },
                React.createElement(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: onStatusToggle, onSelect: onSelect, selections: workflowStates, isOpen: isExpanded, placeholderText: "Status", id: "status-select" }, statusMenuItems)),
            React.createElement(ToolbarFilter, { chips: filters.businessKey, deleteChip: onDeleteChip, categoryName: Category.BUSINESS_KEY },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "businessKey", id: "businessKey", type: "search", "aria-label": "business key", onChange: setBusinessKeyInput, onKeyPress: onEnterClicked, placeholder: "Filter by business key", value: businessKeyInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { variant: "primary", onClick: onApplyFilter, id: "apply-filter-button" }, "Apply filter"))),
        React.createElement(ToolbarGroup, null,
            React.createElement(ToolbarItem, { variant: "separator" }),
            React.createElement(ToolbarGroup, { className: "pf-u-ml-md", id: "workflow-management-buttons" }, buttonItems))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: refresh, id: "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(React.Fragment, null,
        React.createElement(WorkflowInfoModal, { modalTitle: setTitle(titleType, modalTitle), isModalOpen: isModalOpen, operationResult: operations[operationType], handleModalToggle: handleModalToggle, resetSelected: resetSelected, ouiaId: "operation-result" }),
        React.createElement(Toolbar, Object.assign({ id: "data-toolbar-with-filter", className: "pf-m-toggle-group-container kogito-management-console__state-dropdown-list", collapseListedFiltersBreakpoint: "xl", clearAllFilters: resetAllFilters, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "workflow-list-toolbar", ouiaSafe)),
            React.createElement(ToolbarContent, null, toolbarItems))));
};
export default WorkflowListToolbar;
//# sourceMappingURL=WorkflowListToolbar.js.map