var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Grid, GridItem } from "@patternfly/react-core/dist/js/layouts/Grid";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { OverflowMenu, OverflowMenuContent, OverflowMenuGroup, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { WorkflowInfoModal } from "@kie-tools/runtime-tools-components/dist/components/WorkflowInfoModal";
import JobsPanel from "../JobsPanel/JobsPanel";
import "../styles.css";
import WorkflowDetailsPanel from "../WorkflowDetailsPanel/WorkflowDetailsPanel";
import WorkflowDetailsNodeTrigger from "../WorkflowDetailsNodeTrigger/WorkflowDetailsNodeTrigger";
import WorkflowVariables from "../WorkflowVariables/WorkflowVariables";
import WorkflowDetailsMilestonesPanel from "../WorkflowDetailsMilestonesPanel/WorkflowDetailsMilestonesPanel";
import WorkflowDetailsTimelinePanel from "../WorkflowDetailsTimelinePanel/WorkflowDetailsTimelinePanel";
import SwfCombinedEditor from "../SwfCombinedEditor/SwfCombinedEditor";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
const WorkflowDetails = ({ isEnvelopeConnectedToChannel, driver, workflowDetails }) => {
    var _a;
    const [data, setData] = useState({});
    const [jobs, setJobs] = useState([]);
    const [updateJson, setUpdateJson] = useState({});
    const [displayLabel, setDisplayLabel] = useState(false);
    const [displaySuccess, setDisplaySuccess] = useState(false);
    const [errorModalOpen, setErrorModalOpen] = useState(false);
    const [confirmationModal, setConfirmationModal] = useState(false);
    const [variableError, setVariableError] = useState("");
    const [error, setError] = useState("");
    const [isLoading, setIsLoading] = useState(false);
    const [isInfoModalOpen, setIsInfoModalOpen] = useState(false);
    const [infoModalTitle, setInfoModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [infoModalContent, setInfoModalContent] = useState("");
    const handleReload = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        try {
            const workflowResponse = yield driver.workflowDetailsQuery(workflowDetails.id);
            workflowResponse && setData(workflowResponse);
            getAllJobs();
            setIsLoading(false);
        }
        catch (errorString) {
            setError(errorString);
            setIsLoading(false);
        }
    });
    const getAllJobs = () => __awaiter(void 0, void 0, void 0, function* () {
        const jobsResponse = yield driver.jobsQuery(workflowDetails.id);
        jobsResponse && setJobs(jobsResponse);
    });
    useEffect(() => {
        const getVariableJSON = () => {
            if (data && data.id === workflowDetails.id) {
                setUpdateJson(typeof data.variables === "string" ? JSON.parse(data.variables) : data.variables);
            }
        };
        if (isEnvelopeConnectedToChannel) {
            getVariableJSON();
        }
    }, [data]);
    useEffect(() => {
        if (variableError && variableError.length > 0) {
            setErrorModalOpen(true);
        }
    }, [variableError]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setData(workflowDetails);
            getAllJobs();
        }
    }, [isEnvelopeConnectedToChannel]);
    const handleSave = () => {
        driver
            .handleWorkflowVariableUpdate(data, updateJson)
            .then((updatedJson) => {
            setUpdateJson(updatedJson);
            setDisplayLabel(false);
            setDisplaySuccess(true);
            setTimeout(() => {
                setDisplaySuccess(false);
            }, 2000);
        })
            .catch((errorMessage) => {
            setVariableError(errorMessage);
        });
    };
    const updateVariablesButton = () => {
        if (data.serviceUrl !== null) {
            return (React.createElement(Button, { variant: "secondary", id: "save-button", className: "kogito-workflow-details--details__buttonMargin", onClick: handleSave, isDisabled: !displayLabel, "data-testid": "save-button" }, "Save"));
        }
        return React.createElement(React.Fragment, null);
    };
    const handleRefresh = () => {
        if (displayLabel === true) {
            setConfirmationModal(true);
        }
        else {
            handleReload();
        }
    };
    const refreshButton = () => {
        return (React.createElement(Button, { variant: "plain", onClick: () => {
                handleRefresh();
            }, id: "refresh-button", "data-testid": "refresh-button", "aria-label": "Refresh list" },
            React.createElement(SyncIcon, null)));
    };
    const handleInfoModalToggle = () => {
        setIsInfoModalOpen(!isInfoModalOpen);
    };
    const onAbortClick = (workflowInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleWorkflowAbort(workflowInstance);
            setTitleType(TitleType.SUCCESS);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`The workflow ${workflowInstance.processName} was successfully aborted.`);
        }
        catch (abortError) {
            setTitleType(TitleType.FAILURE);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`Failed to abort workflow ${workflowInstance.processName}. Message: ${abortError.message}`);
        }
        finally {
            handleInfoModalToggle();
        }
    });
    const abortButton = () => {
        var _a;
        if ((data.state === WorkflowInstanceState.Active ||
            data.state === WorkflowInstanceState.Error ||
            data.state === WorkflowInstanceState.Suspended) &&
            ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
            data.serviceUrl !== null) {
            return (React.createElement(Button, { variant: "secondary", id: "abort-button", "data-testid": "abort-button", onClick: () => onAbortClick(data) }, "Abort"));
        }
        else {
            return (React.createElement(Button, { variant: "secondary", isDisabled: true }, "Abort"));
        }
    };
    const renderSwfDiagram = () => {
        return (React.createElement(Flex, null,
            React.createElement(FlexItem, null,
                React.createElement(SwfCombinedEditor, { height: 1000, width: 1000, workflowInstance: data }))));
    };
    const renderWorkflowTimeline = () => {
        return (React.createElement(FlexItem, null,
            React.createElement(WorkflowDetailsTimelinePanel, { data: data, jobs: jobs, driver: driver })));
    };
    const renderWorkflowDetails = () => {
        return (React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } },
            React.createElement(FlexItem, null,
                React.createElement(WorkflowDetailsPanel, { workflowInstance: data, driver: driver })),
            data.milestones && data.milestones.length > 0 && (React.createElement(FlexItem, null,
                React.createElement(WorkflowDetailsMilestonesPanel, { milestones: data.milestones })))));
    };
    const renderWorkflowVariables = () => {
        return (React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } }, Object.keys(updateJson).length > 0 && (React.createElement(FlexItem, null,
            React.createElement(WorkflowVariables, { displayLabel: displayLabel, displaySuccess: displaySuccess, setUpdateJson: setUpdateJson, setDisplayLabel: setDisplayLabel, updateJson: updateJson, workflowInstance: data })))));
    };
    const renderPanels = () => {
        return (React.createElement(Flex, { direction: { default: "column" } },
            renderSwfDiagram(),
            React.createElement(Flex, null,
                renderWorkflowDetails(),
                renderWorkflowVariables())));
    };
    const handleConfirmationModal = () => {
        setConfirmationModal(!confirmationModal);
    };
    const handleConfirm = () => {
        window.location.reload();
        handleConfirmationModal();
    };
    const handleCancel = () => {
        handleConfirmationModal();
    };
    const RenderConfirmationModal = () => {
        return (React.createElement(Modal, { title: "", header: React.createElement(React.Fragment, null,
                React.createElement(Title, { headingLevel: "h1", size: TitleSizes["2xl"] },
                    React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--warning-color--100)" }),
                    "Refresh")), variant: ModalVariant.small, isOpen: confirmationModal, onClose: handleConfirmationModal, actions: [
                React.createElement(Button, { key: "Ok", variant: "primary", id: "confirm-button", onClick: handleConfirm }, "Ok"),
                React.createElement(Button, { key: "Cancel", variant: "link", id: "cancel-button", onClick: handleCancel }, "Cancel"),
            ], "aria-label": "Confirmation modal", "aria-labelledby": "Confirmation modal" }, "This action discards changes made on workflow variables."));
    };
    const handleErrorModal = () => {
        setErrorModalOpen(!errorModalOpen);
    };
    const handleRetry = () => {
        handleErrorModal();
        setVariableError("");
        handleSave();
    };
    const handleDiscard = () => {
        handleErrorModal();
        handleRefresh();
    };
    const errorModal = () => {
        return (React.createElement(Modal, { title: "", header: React.createElement(React.Fragment, null,
                React.createElement(Title, { headingLevel: "h1", size: TitleSizes["2xl"] },
                    React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }),
                    "Error")), variant: ModalVariant.small, isOpen: errorModalOpen, onClose: handleErrorModal, actions: [
                React.createElement(Button, { key: "Retry", variant: "primary", id: "retry-button", onClick: handleRetry }, "Retry"),
                React.createElement(Button, { key: "Discard", variant: "link", id: "discard-button", onClick: handleDiscard }, "Discard"),
            ], "aria-label": "Error modal", "aria-labelledby": "Error modal" }, variableError));
    };
    return (React.createElement(React.Fragment, null,
        !error ? (React.createElement(React.Fragment, null, !isLoading && Object.keys(data).length > 0 ? (React.createElement(React.Fragment, null,
            React.createElement(Grid, { hasGutter: true, md: 1, span: 12, lg: 6, xl: 4 },
                React.createElement(GridItem, { span: 12 },
                    React.createElement(Split, { hasGutter: true, component: "div", className: "pf-u-align-items-center" },
                        React.createElement(SplitItem, { isFilled: true },
                            React.createElement(Title, { headingLevel: "h2", size: "4xl", className: "kogito-workflow-details--details__title" },
                                React.createElement(ItemDescriptor, { itemDescription: {
                                        id: data.id,
                                        name: data.processName,
                                        description: data.businessKey,
                                    } }))),
                        React.createElement(SplitItem, null,
                            React.createElement(OverflowMenu, { breakpoint: "lg" },
                                React.createElement(OverflowMenuContent, { isPersistent: true },
                                    React.createElement(OverflowMenuGroup, { groupType: "button", isPersistent: true },
                                        React.createElement(React.Fragment, null,
                                            updateVariablesButton(),
                                            abortButton(),
                                            refreshButton())))))))),
            React.createElement(Flex, { direction: { default: "column", lg: "row" }, className: "kogito-workflow-details--details__marginSpaces" },
                renderPanels(),
                React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } },
                    renderWorkflowTimeline(),
                    React.createElement(FlexItem, null,
                        React.createElement(JobsPanel, { jobs: jobs, driver: driver })),
                    ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
                        data.state !== WorkflowInstanceState.Completed &&
                        data.state !== WorkflowInstanceState.Aborted &&
                        data.serviceUrl &&
                        data.addons.includes("workflow-management") && (React.createElement(FlexItem, null,
                        React.createElement(WorkflowDetailsNodeTrigger, { driver: driver, workflowInstanceData: data })))),
                errorModal(),
                RenderConfirmationModal()))) : (React.createElement(Card, null,
            React.createElement(KogitoSpinner, { spinnerText: "Loading workflow details..." }))))) : (React.createElement(React.Fragment, null, isEnvelopeConnectedToChannel && (React.createElement(Card, { className: "kogito-workflow-details__card-size" },
            React.createElement(Bullseye, null,
                React.createElement(ServerErrors, { error: error, variant: "large" })))))),
        React.createElement(WorkflowInfoModal, { isModalOpen: isInfoModalOpen, handleModalToggle: handleInfoModalToggle, modalTitle: setTitle(titleType, infoModalTitle), modalContent: infoModalContent, workflowName: data && data.processName })));
};
export default WorkflowDetails;
//# sourceMappingURL=WorkflowDetails.js.map