import React, { useState, useEffect } from "react";
import { Card, CardHeader, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Table, TableVariant, TableHeader, TableBody, } from "@patternfly/react-table/dist/js/components/Table";
import Moment from "react-moment";
import JobActionsKebab from "../JobActionsKebab/JobActionsKebab";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { JobsIconCreator } from "../../../utils/Utils";
const JobsPanel = ({ jobs, driver, ouiaId, ouiaSafe }) => {
    const [rows, setRows] = useState([]);
    const columns = [
        {
            title: "Job id",
        },
        {
            title: "Status",
        },
        {
            title: "Expiration time",
        },
        {
            title: "Actions",
        },
    ];
    const createRows = (jobsArray) => {
        const jobRows = [];
        jobsArray.forEach((job) => {
            jobRows.push({
                cells: [
                    {
                        title: (React.createElement(Tooltip, { content: job.id },
                            React.createElement("span", null, job.id.substring(0, 7)))),
                    },
                    {
                        title: JobsIconCreator(job.status),
                    },
                    {
                        title: (React.createElement(React.Fragment, null, job.expirationTime ? (React.createElement(React.Fragment, null,
                            " ",
                            "expires in",
                            " ",
                            React.createElement(Moment, { fromNow: true, ago: true }, job.expirationTime))) : ("N/A"))),
                    },
                    {
                        title: React.createElement(JobActionsKebab, { job: job, driver: driver }),
                    },
                ],
            });
        });
        return jobRows;
    };
    useEffect(() => {
        if (jobs.length > 0) {
            setRows(createRows(jobs));
        }
    }, [jobs]);
    if (jobs.length > 0) {
        return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "workflow-details-jobs-panel")),
            React.createElement(CardHeader, null,
                React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Jobs")),
            React.createElement(CardBody, null,
                React.createElement(Table, { "aria-label": "Workflow details jobs panel", "aria-labelledby": "Workflow details jobs panel", variant: TableVariant.compact, rows: rows, cells: columns },
                    React.createElement(TableHeader, null),
                    React.createElement(TableBody, null)))));
    }
    else {
        return null;
    }
};
export default JobsPanel;
//# sourceMappingURL=JobsPanel.js.map