var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getActionColumn, getColumn } from "../utils/WorkflowDefinitionListUtils";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import WorkflowDefinitionListToolbar from "../WorkflowDefinitionListToolbar/WorkflowDefinitionListToolbar";
const WorkflowDefinitionList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [workflowDefinitionList, setWorkflowDefinitionList] = useState([]);
    const [isLoading, setIsLoading] = useState(true);
    const [filterWorkflowNames, setFilterWorkflowNames] = useState([]);
    const [error, setError] = useState();
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
        return () => {
            setFilterWorkflowNames([]);
        };
    }, [isEnvelopeConnectedToChannel]);
    const init = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            const response = yield driver.getWorkflowDefinitionsQuery();
            const workflowDefinitionFilter = yield driver.getWorkflowDefinitionFilter();
            setFilterWorkflowNames(workflowDefinitionFilter);
            setWorkflowDefinitionList(response);
            setIsLoading(false);
        }
        catch (errorContent) {
            setError(errorContent);
        }
    });
    const columns = [
        getColumn("workflowName", `Workflow Name`),
        getColumn("endpoint", "Endpoint"),
        getActionColumn((workflowDefinition) => {
            driver.openWorkflowForm(workflowDefinition);
        }, (workflowDefinition) => {
            driver.openTriggerCloudEvent(workflowDefinition);
        }),
    ];
    const applyFilter = () => __awaiter(void 0, void 0, void 0, function* () {
        yield driver.setWorkflowDefinitionFilter(filterWorkflowNames);
    });
    const filterWorkflowDefinition = () => {
        if (filterWorkflowNames.length === 0) {
            return workflowDefinitionList;
        }
        return workflowDefinitionList.filter((workflowDefinition) => {
            return filterWorkflowNames.some((filter) => workflowDefinition.workflowName.includes(filter));
        });
    };
    const workflowDefinitionLoadingComponent = (React.createElement(Bullseye, null,
        React.createElement(KogitoSpinner, { spinnerText: `Loading workflow definitions...`, ouiaId: "forms-list-loading-workflow-definitions" })));
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "workflow-definition-list", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(WorkflowDefinitionListToolbar, { filterWorkflowNames: filterWorkflowNames, setFilterWorkflowNames: setFilterWorkflowNames, applyFilter: applyFilter }),
        React.createElement(Divider, null),
        React.createElement(DataTable, { data: filterWorkflowDefinition(), isLoading: isLoading, columns: columns, error: false, LoadingComponent: workflowDefinitionLoadingComponent })));
};
export default WorkflowDefinitionList;
//# sourceMappingURL=WorkflowDefinitionList.js.map