"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCORE_CARD = void 0;
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
var Targets_1 = require("./Targets");
var PREDICATE = "[\n  $v.predicate[] ~> $map(function($v, $i) {\n    $ui2jsonPredicateFactory($v)\n  })\n]";
var COMPLEX_PARTIAL_SCORE = "[\n  $v.ComplexPartialScore ~> $map(function($v, $i) {\n    $v\n  })\n]";
var ATTRIBUTE = "\n$v.Attribute ~> $map(function($v, $i) {\n  {\n    \"type\": \"element\",\n    \"name\": \"Attribute\",\n    \"attributes\": {\n      \"reasonCode\": $v.reasonCode,\n      \"partialScore\": $v.partialScore\n    },\n    \"elements\": $append(".concat(PREDICATE, ", ").concat(COMPLEX_PARTIAL_SCORE, ")\n  }\n})");
var CHARACTERISTIC = "[\n  $v.Characteristic ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\", \n      \"name\": \"Characteristic\", \n      \"attributes\": {\n        \"name\": $v.name,\n        \"reasonCode\": $v.reasonCode,\n        \"baselineScore\": $v.baselineScore\n      },\n      \"elements\": $singletonArray(".concat(ATTRIBUTE, ")\n    }\n  })\n]");
var CHARACTERISTICS = "\n$v.Characteristics ~> $map(function($v, $i) {\n  {\n    \"type\": \"element\",\n    \"name\": \"Characteristics\",\n    \"elements\": $singletonArray(".concat(CHARACTERISTIC, ")\n  }\n})");
exports.SCORE_CARD = "[\n  models[(_type = \"Scorecard\")] ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\",\n      \"name\": \"Scorecard\",\n      \"attributes\": {\n        \"modelName\": $v.modelName,\n        \"functionName\": $v.functionName,\n        \"algorithmName\": $v.algorithmName,\n        \"initialScore\": $v.initialScore,\n        \"useReasonCodes\": $v.useReasonCodes,\n        \"reasonCodeAlgorithm\": $v.reasonCodeAlgorithm,\n        \"baselineScore\": $v.baselineScore,\n        \"baselineMethod\": $v.baselineMethod,\n        \"isScorable\": $v.isScorable\n      },\n      \"elements\": $append(".concat(MiningSchema_1.MINING_SCHEMA, ", \n                    $append(").concat(Output_1.OUTPUT, ", \n                      $append(").concat(CHARACTERISTICS, ",\n                        $append(").concat(ModelStats_1.MODEL_STATS, ",\n                          $append(").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n                            $append(").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n                              $append(").concat(Targets_1.TARGETS, ",\n                                $append([], ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, ")\n                              )\n                            )\n                          )\n                        )\n                      )\n                    )\n                  )\n    }\n  })\n]");
//# sourceMappingURL=Scorecard.js.map