"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PMML2XML = exports.XML2PMML = void 0;
var JSONata = require("jsonata");
var XMLJS = require("xml-js");
var JSON2UI_1 = require("./jsonata/JSON2UI");
var AnomalyDetectionModel_1 = require("./jsonata/json2ui/AnomalyDetectionModel");
var AssociationModel_1 = require("./jsonata/json2ui/AssociationModel");
var BaselineModel_1 = require("./jsonata/json2ui/BaselineModel");
var BayesianNetworkModel_1 = require("./jsonata/json2ui/BayesianNetworkModel");
var ClusteringModel_1 = require("./jsonata/json2ui/ClusteringModel");
var GaussianProcessModel_1 = require("./jsonata/json2ui/GaussianProcessModel");
var GeneralRegressionModel_1 = require("./jsonata/json2ui/GeneralRegressionModel");
var MiningModel_1 = require("./jsonata/json2ui/MiningModel");
var NaiveBayesModel_1 = require("./jsonata/json2ui/NaiveBayesModel");
var NearestNeighborModel_1 = require("./jsonata/json2ui/NearestNeighborModel");
var NeuralNetwork_1 = require("./jsonata/json2ui/NeuralNetwork");
var RegressionModel_1 = require("./jsonata/json2ui/RegressionModel");
var RuleSetModel_1 = require("./jsonata/json2ui/RuleSetModel");
var Scorecard_1 = require("./jsonata/json2ui/Scorecard");
var SequenceModel_1 = require("./jsonata/json2ui/SequenceModel");
var SupportVectorMachineModel_1 = require("./jsonata/json2ui/SupportVectorMachineModel");
var TextModel_1 = require("./jsonata/json2ui/TextModel");
var TimeSeriesModel_1 = require("./jsonata/json2ui/TimeSeriesModel");
var TreeModel_1 = require("./jsonata/json2ui/TreeModel");
var UI2JSON_1 = require("./jsonata/UI2JSON");
var pmml4_4_1 = require("./model/pmml4_4");
function XML2PMML(xml) {
    var doc = XMLJS.xml2js(xml);
    var expression = JSONata(JSON2UI_1.JSON2UI_TRANSFORMATION);
    expression.registerFunction("merge", merge);
    expression.registerFunction("singletonArray", singletonArray);
    expression.registerFunction("anomalyDetectionModelFactory", AnomalyDetectionModel_1.anomalyDetectionModelFactory);
    expression.registerFunction("associationModelFactory", AssociationModel_1.associationModelFactory);
    expression.registerFunction("baselineModelFactory", BaselineModel_1.baselineModelFactory);
    expression.registerFunction("bayesianNetworkModelFactory", BayesianNetworkModel_1.bayesianNetworkModelFactory);
    expression.registerFunction("clusteringModelFactory", ClusteringModel_1.clusteringModelFactory);
    expression.registerFunction("gaussianProcessModelFactory", GaussianProcessModel_1.gaussianProcessModelFactory);
    expression.registerFunction("generalRegressionModelFactory", GeneralRegressionModel_1.generalRegressionModelFactory);
    expression.registerFunction("miningModelFactory", MiningModel_1.miningModelFactory);
    expression.registerFunction("naiveBayesModelFactory", NaiveBayesModel_1.naiveBayesModelFactory);
    expression.registerFunction("nearestNeighborModelFactory", NearestNeighborModel_1.nearestNeighborModelFactory);
    expression.registerFunction("neuralNetworkFactory", NeuralNetwork_1.neuralNetworkFactory);
    expression.registerFunction("regressionModelFactory", RegressionModel_1.regressionModelFactory);
    expression.registerFunction("ruleSetModelFactory", RuleSetModel_1.ruleSetModelFactory);
    expression.registerFunction("scorecardFactory", Scorecard_1.scorecardFactory);
    expression.registerFunction("sequenceModelFactory", SequenceModel_1.sequenceModelFactory);
    expression.registerFunction("supportVectorMachineModelFactory", SupportVectorMachineModel_1.supportVectorMachineModelFactory);
    expression.registerFunction("textModelFactory", TextModel_1.textModelFactory);
    expression.registerFunction("timeSeriesModelFactory", TimeSeriesModel_1.timeSeriesModelFactory);
    expression.registerFunction("treeModelFactory", TreeModel_1.treeModelFactory);
    expression.registerFunction("json2uiSimplePredicateFactory", json2uiSimplePredicateFactory);
    expression.registerFunction("json2uiCompoundPredicateFactory", json2uiCompoundPredicateFactory);
    expression.registerFunction("json2uiTruePredicateFactory", json2uiTruePredicateFactory);
    expression.registerFunction("json2uiFalsePredicateFactory", json2uiFalsePredicateFactory);
    var pmml = expression.evaluate(doc);
    return pmml;
}
exports.XML2PMML = XML2PMML;
function merge(arg) {
    if (typeof arg === undefined) {
        return undefined;
    }
    var result = clone(arg[0]);
    arg.forEach(function (obj) {
        for (var prop in obj) {
            result[prop] = obj[prop];
        }
    });
    return result;
}
function clone(obj) {
    if (obj === null || typeof obj !== "object") {
        return obj;
    }
    var temp = new obj.constructor(obj);
    for (var key in obj) {
        temp[key] = clone(obj[key]);
    }
    return temp;
}
function singletonArray(value) {
    if (value === undefined || value === null) {
        return [];
    }
    if (Array.isArray(value)) {
        return value;
    }
    return [value];
}
function json2uiSimplePredicateFactory() {
    return new pmml4_4_1.SimplePredicate({ field: "", operator: "equal" });
}
function json2uiCompoundPredicateFactory() {
    return new pmml4_4_1.CompoundPredicate({ booleanOperator: "and" });
}
function json2uiTruePredicateFactory() {
    return new pmml4_4_1.True({});
}
function json2uiFalsePredicateFactory() {
    return new pmml4_4_1.False({});
}
function PMML2XML(pmml) {
    var expression = JSONata(UI2JSON_1.UI2JSON_TRANSFORMATION);
    expression.registerFunction("singletonArray", singletonArray);
    var json = expression.evaluate(pmml);
    var xml = XMLJS.js2xml(json, { spaces: 2 });
    return xml;
}
exports.PMML2XML = PMML2XML;
//# sourceMappingURL=Marshaller.js.map