"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PMMLEditorMarshallerService = void 0;
var marshaller_1 = require("../marshaller");
var pmml4_4_1 = require("../marshaller/model/pmml4_4");
var PMMLDocumentData_1 = require("./PMMLDocumentData");
var PMMLModelData_1 = require("./PMMLModelData");
var PMMLFieldData_1 = require("./PMMLFieldData");
var PMMLEditorMarshallerService = (function () {
    function PMMLEditorMarshallerService() {
    }
    PMMLEditorMarshallerService.prototype.getPMMLDocumentData = function (xmlContent) {
        var _this = this;
        var pmml = (0, marshaller_1.XML2PMML)(xmlContent);
        var models = [];
        var document = new PMMLDocumentData_1.PMMLDocumentData(models);
        if (pmml.models) {
            pmml.models.forEach(function (model) {
                var modelData = _this.retrieveModelData(model);
                if (modelData) {
                    models.push(modelData);
                }
            });
        }
        return document;
    };
    PMMLEditorMarshallerService.prototype.retrieveModelData = function (model) {
        var e_1, _a;
        var modelsTypes = [
            pmml4_4_1.AnomalyDetectionModel,
            pmml4_4_1.AssociationModel,
            pmml4_4_1.BayesianNetworkModel,
            pmml4_4_1.BaselineModel,
            pmml4_4_1.ClusteringModel,
            pmml4_4_1.GaussianProcessModel,
            pmml4_4_1.GeneralRegressionModel,
            pmml4_4_1.MiningModel,
            pmml4_4_1.NaiveBayesModel,
            pmml4_4_1.NearestNeighborModel,
            pmml4_4_1.NeuralNetwork,
            pmml4_4_1.RegressionModel,
            pmml4_4_1.RuleSetModel,
            pmml4_4_1.SequenceModel,
            pmml4_4_1.Scorecard,
            pmml4_4_1.SupportVectorMachineModel,
            pmml4_4_1.TextModel,
            pmml4_4_1.TimeSeriesModel,
            pmml4_4_1.TreeModel,
        ];
        var modelData;
        try {
            for (var modelsTypes_1 = __values(modelsTypes), modelsTypes_1_1 = modelsTypes_1.next(); !modelsTypes_1_1.done; modelsTypes_1_1 = modelsTypes_1.next()) {
                var type = modelsTypes_1_1.value;
                if (model instanceof type) {
                    var modelFields = model.MiningSchema.MiningField.map(function (field) { return new PMMLFieldData_1.PMMLFieldData(field.name.toString(), field.usageType); });
                    modelData = new PMMLModelData_1.PMMLModelData(model.modelName == null ? "" : model.modelName, modelFields);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (modelsTypes_1_1 && !modelsTypes_1_1.done && (_a = modelsTypes_1.return)) _a.call(modelsTypes_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return modelData;
    };
    return PMMLEditorMarshallerService;
}());
exports.PMMLEditorMarshallerService = PMMLEditorMarshallerService;
//# sourceMappingURL=PMMLEditorMarshallerService.js.map