import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { ListIcon } from "@patternfly/react-icons/dist/js/icons/list-icon";
import { useCallback, useLayoutEffect, useMemo, useRef, useState } from "react";
import nextId from "react-id-generator";
import { UnitablesBeeTable } from "./bee";
import { FORMS_ID } from "./uniforms";
import "./Unitables.css";
import { UnitablesRow } from "./UnitablesRow";
import setObjectValueByPath from "lodash/set";
import getObjectValueByPath from "lodash/get";
import { diff } from "deep-object-diff";
import cloneDeep from "lodash/cloneDeep";
import { useUnitablesContext } from "./UnitablesContext";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { CubeIcon } from "@patternfly/react-icons/dist/js/icons/cube-icon";
import { usePreviousRef } from "@kie-tools-core/react-hooks/dist/usePreviousRef";
export const Unitables = ({ rows, setRows, openRow, i18n, jsonSchemaBridge, scrollableParentRef, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, configs, setWidth, }) => {
    const [formsDivRendered, setFormsDivRendered] = useState(false);
    const cachedColumnsRows = useRef(new Map());
    const timeout = useRef(undefined);
    const containerRef = useRef(null);
    const previousRows = usePreviousRef(rows);
    const cachedRows = usePreviousRef(cloneDeep(rows));
    const { isBeeTableChange, rowsRefs } = useUnitablesContext();
    const unitablesColumns = useMemo(() => jsonSchemaBridge.getUnitablesColumns(), [jsonSchemaBridge]);
    const inputUid = useMemo(() => nextId(), []);
    const searchRecursively = useCallback((child) => {
        if (!child) {
            return;
        }
        if (child.tagName === "svg" || child.tagName === "path") {
            return;
        }
        if (child.style) {
            child.style.height = "60px";
        }
        if (!child.childNodes) {
            return;
        }
        child.childNodes.forEach(searchRecursively);
    }, []);
    useLayoutEffect(() => {
        var _a, _b;
        const tbody = (_a = containerRef.current) === null || _a === void 0 ? void 0 : _a.getElementsByTagName("tbody")[0];
        const inputsCells = Array.from((_b = tbody === null || tbody === void 0 ? void 0 : tbody.getElementsByTagName("td")) !== null && _b !== void 0 ? _b : []);
        inputsCells.shift();
        inputsCells.forEach((inputCell) => {
            searchRecursively(inputCell.childNodes[0]);
        });
    }, [isBeeTableChange, jsonSchemaBridge, formsDivRendered, rows, containerRef, searchRecursively]);
    const onSubmitRow = useCallback((inputRow, rowIndex, error) => {
        if (isBeeTableChange.current) {
            if (timeout.current) {
                clearTimeout(timeout.current);
            }
            timeout.current = window.setTimeout(() => {
                if (cachedRows.current) {
                    setRows(cloneDeep(cachedRows.current));
                }
                cachedColumnsRows.current.clear();
                isBeeTableChange.current = false;
            }, 0);
            const changedValues = diff(inputRow, previousRows.current[rowIndex]);
            if (!changedValues) {
                return;
            }
            const changedColumns = Object.entries(changedValues).flatMap(([columnName, columnValue]) => {
                if (columnValue !== null && typeof columnValue === "object") {
                    return Object.keys(columnValue).map((columnInsidePropertyName) => `${columnName}.${columnInsidePropertyName}`);
                }
                return columnName;
            });
            let cachedColumns = cachedColumnsRows.current.get(rowIndex);
            if (!cachedColumns) {
                cachedColumns = new Set();
                cachedColumnsRows.current.set(rowIndex, cachedColumns);
            }
            changedColumns.forEach((changedKey) => {
                if (!cachedColumns.has(changedKey)) {
                    setObjectValueByPath(cachedRows.current[rowIndex], changedKey, getObjectValueByPath(inputRow, changedKey));
                    cachedColumns.add(changedKey);
                }
            });
        }
        else {
            setRows((previousInputRows) => {
                const newInputRows = cloneDeep(previousInputRows);
                newInputRows[rowIndex] = inputRow;
                return newInputRows;
            });
        }
    }, [cachedRows, isBeeTableChange, previousRows, setRows]);
    const saveRowRef = useCallback((ref, rowIndex) => {
        if (ref) {
            rowsRefs.set(rowIndex, ref);
        }
    }, [rowsRefs]);
    const rowWrapper = useCallback(({ children, rowIndex, row, }) => {
        return (_jsx(UnitablesRow, Object.assign({ ref: (ref) => saveRowRef(ref, rowIndex), formsId: FORMS_ID, rowIndex: rowIndex, rowInput: row, jsonSchemaBridge: jsonSchemaBridge, onSubmitRow: onSubmitRow }, { children: children }), rowIndex));
    }, [jsonSchemaBridge, onSubmitRow, saveRowRef]);
    return (_jsxs(_Fragment, { children: [unitablesColumns.length > 0 && rows.length > 0 && formsDivRendered ? (_jsxs("div", Object.assign({ style: { display: "flex" }, ref: containerRef }, { children: [_jsxs("div", Object.assign({ className: "kie-tools--unitables-open-on-form-container", style: { display: "flex", flexDirection: "column" } }, { children: [_jsx(OutsideRowMenu, Object.assign({ height: 63, isFirstChild: true }, { children: `#` })), _jsx(OutsideRowMenu, Object.assign({ height: 64, borderBottomSizeBasis: 1 }, { children: `#` })), rows.map((_, rowIndex) => (_jsx(Tooltip, Object.assign({ content: `Open row ${rowIndex + 1} in the form view` }, { children: _jsx(OutsideRowMenu, Object.assign({ height: 61, isLastChild: rowIndex === rows.length - 1 }, { children: _jsx(Button, Object.assign({ className: "kie-tools--masthead-hoverable", variant: ButtonVariant.plain, onClick: () => openRow(rowIndex) }, { children: _jsx(ListIcon, {}) })) })) }), rowIndex)))] })), _jsx(UnitablesBeeTable, { rowWrapper: rowWrapper, scrollableParentRef: scrollableParentRef, i18n: i18n, rows: rows, columns: unitablesColumns, id: inputUid, onRowAdded: onRowAdded, onRowDuplicated: onRowDuplicated, onRowReset: onRowReset, onRowDeleted: onRowDeleted, configs: configs, setWidth: setWidth, bridge: jsonSchemaBridge })] }))) : (_jsx(EmptyUnitables, {})), _jsx("div", { ref: () => setFormsDivRendered(true), id: FORMS_ID })] }));
};
function OutsideRowMenu({ children, height, isLastChild = false, isFirstChild = false, borderBottomSizeBasis = 1, }) {
    return (_jsx("div", Object.assign({ style: {
            width: "60px",
            height: `${height + (isFirstChild ? 3 : 0) + (isLastChild ? 1.6 : 0)}px`,
            minHeight: `${height + (isFirstChild ? 3 : 0) + (isLastChild ? 1.6 : 0)}px`,
            display: "flex",
            fontSize: "16px",
            color: "gray",
            alignItems: "center",
            justifyContent: "center",
            borderBottom: `${isLastChild ? 3 : borderBottomSizeBasis}px solid lightgray`,
            borderTop: `${isFirstChild ? 2 : 0}px solid lightgray`,
            borderLeft: "3px solid lightgray",
        } }, { children: children })));
}
function EmptyUnitables() {
    return (_jsx("div", Object.assign({ style: { width: "50vw" } }, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubeIcon }), _jsx(TextContent, { children: _jsx(Text, Object.assign({ component: "h2" }, { children: "No inputs node yet..." })) }), _jsx(EmptyStateBody, { children: _jsx(TextContent, { children: "Add an input node and see a custom table here." }) })] }) })));
}
//# sourceMappingURL=Unitables.js.map