import React from "react";
const DATA_INDEX_URL_PARAM = "dataIndexUrl";
const DASHBOARD_PARAM = "import";
const WORKFLOW_ID = "workflowId";
const MonitoringWebapp = ({ dashboard, dataIndexUrl, workflow }) => {
    const queryParams = new URLSearchParams();
    if (dataIndexUrl) {
        queryParams.set(DATA_INDEX_URL_PARAM, dataIndexUrl);
    }
    if (dashboard) {
        queryParams.set(DASHBOARD_PARAM, dashboard);
    }
    if (workflow) {
        queryParams.set(WORKFLOW_ID, workflow);
    }
    return (React.createElement("iframe", { src: `resources/webapp/monitoring-webapp/index.html?${queryParams.toString()}`, style: { width: "100%", height: "100%", padding: "10px" } }));
};
export default MonitoringWebapp;
//# sourceMappingURL=MonitoringWebapp.js.map