import { Form } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface FormDisplayerInitArgs {
    form: Form;
    data?: any;
    context?: Record<string, any>;
}
export declare type FormSubmitContext = {
    params?: Record<string, string>;
};
export declare enum FormOpenedState {
    OPENED = "opened",
    ERROR = "error"
}
export declare type FormOpened = {
    state: FormOpenedState;
    size: FormSize;
};
export declare type FormSize = {
    width: number;
    height: number;
};
export declare enum FormSubmitResponseType {
    SUCCESS = "success",
    FAILURE = "failure"
}
export declare type FormSubmitResponse = {
    type: FormSubmitResponseType;
    info: any;
};
export interface Association {
    origin: string;
    envelopeServerId: string;
}
export interface FormResources {
    scripts: {
        [key: string]: string;
    };
    styles: {
        [key: string]: string;
    };
}
//# sourceMappingURL=types.d.ts.map