"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidationStore = void 0;
var ownKeys = Reflect.ownKeys;
var lodash_1 = require("lodash");
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationStore = (function () {
    function ValidationStore() {
        var _this = this;
        this.registry = {};
        this.set = function (path, entry) {
            (0, lodash_1.set)(_this.registry, path.path, entry);
        };
        this.get = function (path) {
            var node = path.path === "" ? _this.registry : (0, lodash_1.get)(_this.registry, path.path);
            if (node === undefined) {
                return [];
            }
            if (node instanceof ValidationRegistry_1.ValidationEntry) {
                return [node];
            }
            if (node.level !== undefined) {
                return [node];
            }
            if (!(node instanceof Object)) {
                return [];
            }
            var mapped = ownKeys(node).map(function (key) { return _this.get({ path: _this.childPath(path.path, String(key)) }); });
            if (mapped.length === 0) {
                return [];
            }
            return mapped.reduce(function (pv, cv) {
                return pv.concat(cv);
            });
        };
        this.childPath = function (parentPath, key) {
            if (parentPath === "") {
                return key;
            }
            return "".concat(parentPath, ".").concat(key);
        };
        this.clear = function (path) {
            (0, lodash_1.unset)(_this.registry, path.path);
        };
    }
    return ValidationStore;
}());
exports.ValidationStore = ValidationStore;
//# sourceMappingURL=ValidationStore.js.map