"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateCharacteristics = exports.validateCharacteristic = void 0;
var Attributes_1 = require("./Attributes");
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateCharacteristic = function (modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry) {
    if (scorecardProperties.useReasonCodes !== false) {
        if (characteristic.reasonCode === undefined && (0, Attributes_1.areAttributesReasonCodesMissing)(characteristic.Attribute)) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forCharacteristics()
                .forCharacteristic(characteristicIndex)
                .forReasonCode()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "".concat(characteristic.name, ": Reason code is required")));
        }
        if (scorecardProperties.baselineScore === undefined && characteristic.baselineScore === undefined) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forCharacteristics()
                .forCharacteristic(characteristicIndex)
                .forBaselineScore()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "".concat(characteristic.name, ": Baseline score is required")));
        }
    }
    (0, Attributes_1.validateAttributes)(modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry);
};
exports.validateCharacteristic = validateCharacteristic;
var validateCharacteristics = function (modelIndex, scorecardProperties, characteristics, miningFields, validationRegistry) {
    characteristics.forEach(function (characteristic, characteristicIndex) {
        return (0, exports.validateCharacteristic)(modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry);
    });
};
exports.validateCharacteristics = validateCharacteristics;
//# sourceMappingURL=Characteristics.js.map