"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiningSchemaFieldReducer = void 0;
var Actions_1 = require("./Actions");
var paths_1 = require("../paths");
var MiningSchema_1 = require("../validation/MiningSchema");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var MiningSchemaFieldReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.UpdateMiningSchemaField:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forMiningSchema().forMiningField().build(), function (draft) {
                    var miningSchemaIndex = action.payload.miningSchemaIndex;
                    var _areLowHighValuesRequired = (0, MiningSchema_1.areLowHighValuesRequired)(action.payload.outliers);
                    var _isMissingValueReplacementRequired = (0, MiningSchema_1.isMissingValueReplacementRequired)(action.payload.missingValueTreatment);
                    var _isInvalidValueReplacementRequired = (0, MiningSchema_1.isInvalidValueReplacementRequired)(action.payload.invalidValueTreatment);
                    if (miningSchemaIndex >= 0 && miningSchemaIndex < draft.length) {
                        var outlierChanged = draft[miningSchemaIndex].outliers !== action.payload.outliers;
                        var missingValueTreatmentChanged = draft[miningSchemaIndex].missingValueTreatment !== action.payload.missingValueTreatment;
                        var invalidValueTreatmentChanged = draft[miningSchemaIndex].invalidValueTreatment !== action.payload.invalidValueTreatment;
                        var clearLowHighValues = outlierChanged && !_areLowHighValuesRequired;
                        var clearMissingValueReplacement = missingValueTreatmentChanged && !_isMissingValueReplacementRequired;
                        var clearInvalidValueReplacement = invalidValueTreatmentChanged && !_isInvalidValueReplacementRequired;
                        var newLowValue = clearLowHighValues ? undefined : action.payload.lowValue;
                        var newHighValue = clearLowHighValues ? undefined : action.payload.highValue;
                        var newMissingValueReplacement = clearMissingValueReplacement
                            ? undefined
                            : action.payload.missingValueReplacement;
                        var newInvalidValueReplacement = clearInvalidValueReplacement
                            ? undefined
                            : action.payload.invalidValueReplacement;
                        draft[miningSchemaIndex] = __assign(__assign({}, draft[miningSchemaIndex]), { name: action.payload.name, usageType: action.payload.usageType, optype: action.payload.optype, importance: action.payload.importance, outliers: action.payload.outliers, lowValue: newLowValue, highValue: newHighValue, missingValueTreatment: action.payload.missingValueTreatment, missingValueReplacement: newMissingValueReplacement, invalidValueTreatment: action.payload.invalidValueTreatment, invalidValueReplacement: newInvalidValueReplacement });
                    }
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchemaIndex = action.payload.miningSchemaIndex;
                    var dataDictionary = (0, PMMLModelHelper_1.getDataDictionary)(pmml);
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var miningField = (0, PMMLModelHelper_1.getMiningField)(pmml, modelIndex, miningSchemaIndex);
                    if (dataDictionary !== undefined && miningSchema !== undefined && miningField !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningSchemaIndex).build());
                        (0, MiningSchema_1.validateMiningField)(modelIndex, miningSchemaIndex, miningField, validationRegistry);
                        (0, MiningSchema_1.validateMiningFieldDataFieldReference)(modelIndex, dataDictionary.DataField, miningSchemaIndex, miningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.UpdateDataDictionaryField:
                state.forEach(function (mf, index) {
                    if (mf.name === action.payload.originalName) {
                        historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forMiningSchema().forMiningField().build(), function (draft) {
                            draft[index] = __assign(__assign({}, draft[index]), { name: action.payload.dataField.name });
                        });
                    }
                });
            case Actions_1.Actions.AddDataDictionaryField:
            case Actions_1.Actions.DeleteDataDictionaryField:
            case Actions_1.Actions.AddBatchDataDictionaryFields:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forMiningSchema().forMiningField().build(), function () {
                }, function (pmml) {
                    if (action.payload.modelIndex !== undefined) {
                        var modelIndex_1 = action.payload.modelIndex;
                        var dataDictionary = (0, PMMLModelHelper_1.getDataDictionary)(pmml);
                        var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex_1);
                        if (dataDictionary !== undefined && miningSchema !== undefined) {
                            miningSchema.MiningField.forEach(function (miningField, miningFieldIndex) {
                                validationRegistry.clear((0, paths_1.Builder)()
                                    .forModel(modelIndex_1)
                                    .forMiningSchema()
                                    .forMiningField(miningFieldIndex)
                                    .forDataFieldMissing()
                                    .build());
                            });
                            (0, MiningSchema_1.validateMiningFieldsDataFieldReference)(modelIndex_1, dataDictionary.DataField, miningSchema.MiningField, validationRegistry);
                        }
                    }
                });
                break;
            case Actions_1.Actions.Validate:
                if (action.payload.modelIndex !== undefined) {
                    var modelIndex = action.payload.modelIndex;
                    (0, MiningSchema_1.validateMiningFields)(modelIndex, state, validationRegistry);
                }
        }
        return state;
    };
};
exports.MiningSchemaFieldReducer = MiningSchemaFieldReducer;
//# sourceMappingURL=MiningSchemaFieldReducer.js.map