"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataDictionaryFieldReducer = void 0;
var Actions_1 = require("./Actions");
var validation_1 = require("../validation");
var paths_1 = require("../paths");
var DataDictionaryFieldReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.UpdateDataDictionaryField:
                var dataField_1 = action.payload.dataField;
                var dataDictionaryIndex_1 = action.payload.dataDictionaryIndex;
                historyService.batch(state, (0, paths_1.Builder)().forDataDictionary().forDataField().build(), function (draft) {
                    var _a;
                    if (dataDictionaryIndex_1 >= 0 && dataDictionaryIndex_1 < draft.length) {
                        if ((0, validation_1.shouldConstraintsBeCleared)(dataField_1, draft[dataDictionaryIndex_1].isCyclic, draft[dataDictionaryIndex_1].dataType, draft[dataDictionaryIndex_1].optype)) {
                            delete dataField_1.Interval;
                            dataField_1.Value = (_a = dataField_1.Value) === null || _a === void 0 ? void 0 : _a.filter(function (value) { return value.property === "invalid" || value.property === "missing"; });
                        }
                        if (dataField_1.isCyclic === "1" && dataField_1.optype === "ordinal" && (0, validation_1.hasIntervals)(dataField_1)) {
                            delete dataField_1.Interval;
                        }
                        if (dataField_1.optype === "categorical" && dataField_1.isCyclic !== undefined) {
                            delete dataField_1.isCyclic;
                        }
                        if (((dataField_1.isCyclic === "1" && dataField_1.optype === "ordinal") ||
                            (dataField_1.dataType === "string" && dataField_1.optype === "ordinal")) &&
                            !(0, validation_1.hasValidValues)(dataField_1)) {
                            dataField_1.Value = (dataField_1.Value || []).concat({ value: "" });
                        }
                        draft[dataDictionaryIndex_1] = dataField_1;
                    }
                }, function () {
                    validationRegistry.clear((0, paths_1.Builder)().forDataDictionary().forDataField(dataDictionaryIndex_1).build());
                    (0, validation_1.validateDataField)(dataField_1, dataDictionaryIndex_1, validationRegistry);
                });
                break;
            case Actions_1.Actions.Validate:
                validationRegistry.clear((0, paths_1.Builder)().forDataDictionary().forDataField().build());
                (0, validation_1.validateDataFields)(state, validationRegistry);
        }
        return state;
    };
};
exports.DataDictionaryFieldReducer = DataDictionaryFieldReducer;
//# sourceMappingURL=DataDictionaryFieldReducer.js.map