"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var TextArea_1 = require("@patternfly/react-core/dist/js/components/TextArea");
require("./OutputsBatchAdd.scss");
var OutputsBatchAdd = function (_a) {
    var onAdd = _a.onAdd, onCancel = _a.onCancel;
    var _b = __read((0, react_1.useState)(""), 2), input = _b[0], setInput = _b[1];
    var _c = __read((0, react_1.useState)("default"), 2), inputValidation = _c[0], setInputValidation = _c[1];
    (0, react_1.useEffect)(function () {
        var _a;
        (_a = document.querySelector("#outputs")) === null || _a === void 0 ? void 0 : _a.focus();
    }, []);
    var handleInputChange = function (value) {
        setInput(value);
    };
    var validateInput = function () {
        var validation = input.trim().length > 0 ? "success" : "error";
        setInputValidation(validation);
        return validation;
    };
    var handleSubmit = function (event) {
        if (validateInput() === "success") {
            onAdd(input);
        }
        event.preventDefault();
    };
    return ((0, jsx_runtime_1.jsx)("section", { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Text_1.TextContent, { children: [(0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ component: Text_1.TextVariants.h3 }, { children: "Add Multiple Output Fields" })), (0, jsx_runtime_1.jsxs)(Text_1.Text, __assign({ component: Text_1.TextVariants.p }, { children: ["You can add multiple outputs by entering their names below. Add them one per line.", (0, jsx_runtime_1.jsx)("br", {}), "They will be created with the default type of ", (0, jsx_runtime_1.jsx)("em", { children: "String" }), ". You will be able to edit them later."] }))] }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Form_1.Form, __assign({ onSubmit: handleSubmit, style: { gridGap: 0 } }, { children: [(0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Outputs", fieldId: "outputs", isRequired: true, validated: inputValidation, helperTextInvalid: "Please enter at least one Output name" }, { children: (0, jsx_runtime_1.jsx)(TextArea_1.TextArea, { className: "outputs-container__multiple-outputs", value: input, onChange: handleInputChange, name: "outputs", isRequired: true, id: "outputs", placeholder: "First Output\nSecond Output\n..." }) })), (0, jsx_runtime_1.jsxs)(Form_1.ActionGroup, { children: [(0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", type: "submit" }, { children: "Add Them" })), (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "link", onClick: function () { return onCancel(); } }, { children: "Never mind" }))] })] })) })] })) }));
};
exports.default = OutputsBatchAdd;
//# sourceMappingURL=OutputsBatchAdd.js.map