"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Bullseye_1 = require("@patternfly/react-core/dist/js/layouts/Bullseye");
var EditorScorecard_1 = require("../../EditorScorecard");
var EmptyStateNoOutput_1 = require("./EmptyStateNoOutput");
var OutputFieldRow_1 = require("../molecules/OutputFieldRow");
var OutputFieldEditRow_1 = require("../molecules/OutputFieldEditRow");
require("./OutputFieldsTable.scss");
var OutputFieldsTable = function (props) {
    var modelIndex = props.modelIndex, outputs = props.outputs, selectedOutputIndex = props.selectedOutputIndex, setSelectedOutputIndex = props.setSelectedOutputIndex, validateOutputFieldName = props.validateOutputFieldName, viewExtendedProperties = props.viewExtendedProperties, onAddOutputField = props.onAddOutputField, onDeleteOutputField = props.onDeleteOutputField, onCommitAndClose = props.onCommitAndClose, onCommit = props.onCommit, onCancel = props.onCancel;
    var addOutputRowRef = (0, react_1.useRef)(null);
    var _a = __read((0, react_1.useState)(undefined), 2), outputFieldFocusIndex = _a[0], setOutputFieldFocusIndex = _a[1];
    var _b = (0, EditorScorecard_1.useOperation)(), activeOperation = _b.activeOperation, setActiveOperation = _b.setActiveOperation;
    (0, react_1.useEffect)(function () {
        if (activeOperation === EditorScorecard_1.Operation.UPDATE_OUTPUT && addOutputRowRef.current) {
            addOutputRowRef.current.scrollIntoView({ behavior: "smooth" });
        }
    }, [activeOperation]);
    (0, react_1.useEffect)(function () {
        if (selectedOutputIndex === outputs.length) {
            setSelectedOutputIndex(undefined);
            setActiveOperation(EditorScorecard_1.Operation.NONE);
        }
    }, [outputs, selectedOutputIndex]);
    (0, react_1.useEffect)(function () {
        var _a;
        if (outputFieldFocusIndex !== undefined) {
            (_a = document.querySelector("#output-field-n".concat(outputFieldFocusIndex))) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [outputs, outputFieldFocusIndex]);
    var onEdit = function (index) {
        setSelectedOutputIndex(index);
        setActiveOperation(EditorScorecard_1.Operation.UPDATE_OUTPUT);
    };
    var handleDelete = function (index, interaction) {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setOutputFieldFocusIndex(index);
        }
        setSelectedOutputIndex(undefined);
    };
    var onDelete = function (index) {
        if (index !== undefined) {
            onDeleteOutputField(index);
        }
    };
    var onValidateOutputFieldName = function (index, nameToValidate) {
        return validateOutputFieldName(index, nameToValidate);
    };
    return ((0, jsx_runtime_1.jsxs)(Form_1.Form, __assign({ "data-testid": "output-fields-table", onSubmit: function (e) {
            e.stopPropagation();
            e.preventDefault();
        } }, { children: [(0, jsx_runtime_1.jsx)("section", { children: outputs.map(function (o, index) {
                    var isRowInEditMode = selectedOutputIndex === index && activeOperation === EditorScorecard_1.Operation.UPDATE_OUTPUT;
                    return ((0, jsx_runtime_1.jsxs)("article", __assign({ className: "editable-item output-item-n".concat(index, " ").concat(isRowInEditMode ? "editable-item--editing" : "") }, { children: [isRowInEditMode && ((0, jsx_runtime_1.jsx)("div", __assign({ ref: addOutputRowRef }, { children: (0, jsx_runtime_1.jsx)(OutputFieldEditRow_1.default, { modelIndex: modelIndex, outputField: o, outputFieldIndex: index, validateOutputName: function (_name) { return onValidateOutputFieldName(index, _name); }, viewExtendedProperties: viewExtendedProperties, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) }))), !isRowInEditMode && ((0, jsx_runtime_1.jsx)(OutputFieldRow_1.default, { modelIndex: modelIndex, outputField: o, outputFieldIndex: index, onEditOutputField: function () { return onEdit(index); }, onDeleteOutputField: function (interaction) { return handleDelete(index, interaction); } }))] }), index));
                }) }), outputs.length === 0 && ((0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, { children: (0, jsx_runtime_1.jsx)(EmptyStateNoOutput_1.EmptyStateNoOutput, { onAddOutputField: onAddOutputField }) }))] })));
};
exports.default = OutputFieldsTable;
//# sourceMappingURL=OutputFieldsTable.js.map