"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var arrow_alt_circle_left_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var atoms_1 = require("../../EditorScorecard/atoms");
require("./MiningSchemaPropertiesEdit.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var MiningSchema_1 = require("../../../validation/MiningSchema");
var MiningSchemaPropertiesEdit = function (_a) {
    var _b, _c, _d, _e, _f, _g, _h;
    var modelIndex = _a.modelIndex, miningFieldIndex = _a.miningFieldIndex, field = _a.field, onSave = _a.onSave, onClose = _a.onClose;
    var _j = __read((0, react_1.useState)((_b = field.usageType) !== null && _b !== void 0 ? _b : ""), 2), usageType = _j[0], setUsageType = _j[1];
    var _k = __read((0, react_1.useState)((_c = field.optype) !== null && _c !== void 0 ? _c : ""), 2), opType = _k[0], setOpType = _k[1];
    var _l = __read((0, react_1.useState)(field.importance), 2), importance = _l[0], setImportance = _l[1];
    var _m = __read((0, react_1.useState)((_d = field.outliers) !== null && _d !== void 0 ? _d : ""), 2), outliers = _m[0], setOutliers = _m[1];
    var _o = __read((0, react_1.useState)(field.lowValue), 2), lowValue = _o[0], setLowValue = _o[1];
    var _p = __read((0, react_1.useState)(field.highValue), 2), highValue = _p[0], setHighValue = _p[1];
    var _q = __read((0, react_1.useState)((_e = field.missingValueReplacement) !== null && _e !== void 0 ? _e : ""), 2), missingValueReplacement = _q[0], setMissingValueReplacement = _q[1];
    var _r = __read((0, react_1.useState)((_f = field.missingValueTreatment) !== null && _f !== void 0 ? _f : ""), 2), missingValueTreatment = _r[0], setMissingValueTreatment = _r[1];
    var _s = __read((0, react_1.useState)((_g = field.invalidValueTreatment) !== null && _g !== void 0 ? _g : ""), 2), invalidValueTreatment = _s[0], setInvalidValueTreatment = _s[1];
    var _t = __read((0, react_1.useState)((_h = field.invalidValueReplacement) !== null && _h !== void 0 ? _h : ""), 2), invalidValueReplacement = _t[0], setInvalidValueReplacement = _t[1];
    var _u = __read((0, react_1.useState)(false), 2), submitChanges = _u[0], setSubmitChanges = _u[1];
    var handleSave = function () {
        var updatedField = { name: field.name };
        if (usageType.length > 0) {
            updatedField.usageType = usageType;
        }
        if (opType.length > 0) {
            updatedField.optype = opType;
        }
        if (typeof importance === "number") {
            updatedField.importance = importance;
        }
        if (outliers) {
            updatedField.outliers = outliers;
        }
        if (typeof lowValue === "number") {
            updatedField.lowValue = lowValue;
        }
        if (typeof highValue === "number") {
            updatedField.highValue = highValue;
        }
        if (missingValueReplacement) {
            updatedField.missingValueReplacement = missingValueReplacement;
        }
        if (missingValueTreatment.length > 0) {
            updatedField.missingValueTreatment = missingValueTreatment;
        }
        if (invalidValueReplacement) {
            updatedField.invalidValueReplacement = invalidValueReplacement;
        }
        if (invalidValueTreatment.length > 0) {
            updatedField.invalidValueTreatment = invalidValueTreatment;
        }
        onSave(updatedField);
        setSubmitChanges(false);
    };
    (0, react_1.useEffect)(function () {
        if (submitChanges) {
            handleSave();
        }
    }, [submitChanges]);
    (0, react_1.useEffect)(function () {
        var _a, _b, _c, _d, _e, _f, _g;
        setUsageType((_a = field.usageType) !== null && _a !== void 0 ? _a : "");
        setOpType((_b = field.optype) !== null && _b !== void 0 ? _b : "");
        setImportance(field.importance);
        setOutliers((_c = field.outliers) !== null && _c !== void 0 ? _c : "");
        setLowValue(field.lowValue);
        setHighValue(field.highValue);
        setMissingValueReplacement((_d = field.missingValueReplacement) !== null && _d !== void 0 ? _d : "");
        setMissingValueTreatment((_e = field.missingValueTreatment) !== null && _e !== void 0 ? _e : "");
        setInvalidValueTreatment((_f = field.invalidValueTreatment) !== null && _f !== void 0 ? _f : "");
        setInvalidValueReplacement((_g = field.invalidValueReplacement) !== null && _g !== void 0 ? _g : "");
    }, [field]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validationsImportance = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forImportance().build());
    }, [modelIndex, miningFieldIndex, field]);
    var validationsLowValue = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build());
    }, [modelIndex, miningFieldIndex, field]);
    var validationsHighValue = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build());
    }, [modelIndex, miningFieldIndex, field]);
    var validationsMissingValueReplacement = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forMiningSchema()
            .forMiningField(miningFieldIndex)
            .forMissingValueReplacement()
            .build());
    }, [modelIndex, miningFieldIndex, field]);
    var validationsInvalidValueReplacement = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forMiningSchema()
            .forMiningField(miningFieldIndex)
            .forInvalidValueReplacement()
            .build());
    }, [modelIndex, miningFieldIndex, field]);
    var enableLowValueComponent = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.areLowHighValuesRequired)(field.outliers) || field.lowValue !== undefined; }, [modelIndex, miningFieldIndex, field]);
    var enableHighValueComponent = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.areLowHighValuesRequired)(field.outliers) || field.highValue !== undefined; }, [modelIndex, miningFieldIndex, field]);
    var enableMissingValueComponent = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.isMissingValueReplacementRequired)(field.missingValueTreatment) || field.missingValueReplacement !== undefined; }, [modelIndex, miningFieldIndex, field]);
    var enableInvalidValueComponent = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.isInvalidValueReplacementRequired)(field.invalidValueTreatment) || field.invalidValueReplacement !== undefined; }, [modelIndex, miningFieldIndex, field]);
    var toNumberOrUndefined = function (value) {
        var _value = Number.parseFloat(value);
        return isNaN(_value) ? undefined : _value;
    };
    return ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true, className: "mining-schema__edit" }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Title_1.Title, __assign({ headingLevel: "h4", size: Title_1.TitleSizes.xl }, { children: [(0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "link", isInline: true, onClick: onClose }, { children: field.name })), "\u00A0/\u00A0Properties"] })) }), (0, jsx_runtime_1.jsxs)(Stack_1.StackItem, { children: [(0, jsx_runtime_1.jsx)("section", __assign({ className: "mining-schema__edit__form" }, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "mining-schema__properties__field", label: "Field Usage Type", fieldId: "usageType" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: "usageType", items: [
                                                                "",
                                                                "active",
                                                                "predicted",
                                                                "target",
                                                                "supplementary",
                                                                "group",
                                                                "order",
                                                                "frequencyWeight",
                                                                "analysisWeight",
                                                            ], onSelect: function (selection) {
                                                                setUsageType(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: usageType, "data-ouia-component-id": "usage-type", "data-ouia-component-type": "option-box" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "mining-schema__properties__field", label: "Field Op Type", fieldId: "opType" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: "opType", items: ["", "categorical", "ordinal", "continuous"], onSelect: function (selection) {
                                                                setOpType(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: opType }) })) })] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "mining-schema__properties__field", label: "Importance", fieldId: "importance", helperText: validationsImportance.length === 0 ? "" : validationsImportance[0].message, validated: validationsImportance.length === 0 ? "default" : "warning" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", min: 0, max: 1, id: "importance", name: "importance", "aria-describedby": "Importance", value: importance !== null && importance !== void 0 ? importance : "", ouiaId: "importance", "data-ouia-component-type": "double-input", validated: validationsImportance.length === 0 ? "default" : "warning", onChange: function (value) { return setImportance(toNumberOrUndefined(value)); }, onBlur: function () {
                                                    if (importance !== undefined) {
                                                        var _importance = importance;
                                                        if (_importance < 0) {
                                                            _importance = 0;
                                                            setImportance(_importance);
                                                        }
                                                        else if (_importance > 1) {
                                                            _importance = 1;
                                                            setImportance(_importance);
                                                        }
                                                    }
                                                    handleSave();
                                                } }) })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "mining-schema__properties__field", label: "Outliers Treatment Method", fieldId: "outliers" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: "outliers", items: ["", "asIs", "asMissingValues", "asExtremeValues"], onSelect: function (selection) {
                                                                setOutliers(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: outliers, "data-ouia-component-id": "outliers" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Low Value", fieldId: "lowValue", className: "mining-schema__properties__field", helperText: validationsLowValue.length === 0 ? "" : validationsLowValue[0].message, validated: validationsLowValue.length === 0 ? "default" : "warning", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Low Value is required when Outliers is \"asExtremeValues\" or \"asMissingValues\"" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Low Value field", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "lowValue", name: "lowValue", "aria-describedby": "Low Value", value: lowValue !== null && lowValue !== void 0 ? lowValue : "", validated: validationsLowValue.length === 0 ? "default" : "warning", isDisabled: !enableLowValueComponent, placeholder: !enableLowValueComponent ? "<Not needed>" : "", className: !enableLowValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: function (value) { return setLowValue(toNumberOrUndefined(value)); }, onBlur: handleSave, ouiaId: "low-value" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "High Value", fieldId: "highValue", className: "mining-schema__properties__field", helperText: validationsHighValue.length === 0 ? "" : validationsHighValue[0].message, validated: validationsHighValue.length === 0 ? "default" : "warning", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "High Value is required when Outliers is \"asExtremeValues\" or \"asMissingValues\"" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for High Value field", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "highValue", name: "highValue", "aria-describedby": "High Value", value: highValue !== null && highValue !== void 0 ? highValue : "", validated: validationsHighValue.length === 0 ? "default" : "warning", isDisabled: !enableHighValueComponent, placeholder: !enableHighValueComponent ? "<Not needed>" : "", className: !enableHighValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: function (value) { return setHighValue(toNumberOrUndefined(value)); }, onBlur: handleSave, ouiaId: "high-value" }) })) })] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Missing Value Treatment Method", fieldId: "missingValueTreatment" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: "missingValueTreatment", items: ["", "asIs", "asMean", "asMode", "asMedian", "asValue", "returnInvalid"], onSelect: function (selection) {
                                                                setMissingValueTreatment(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: missingValueTreatment }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Missing Value Replacement", fieldId: "missingValueReplacement", validated: validationsMissingValueReplacement.length === 0 ? "default" : "warning", helperText: validationsMissingValueReplacement[0] ? validationsMissingValueReplacement[0].message : "", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Missing Value Replacement is required when Missing Value Treatment is \"asMean\", \"asMedian\" or \"asMode\"" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Missing Value Replacement field", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "missingValueReplacement", name: "missingValueReplacement", "aria-describedby": "Missing Value Replacement", value: missingValueReplacement, validated: validationsMissingValueReplacement.length === 0 ? "default" : "warning", isDisabled: !enableMissingValueComponent, placeholder: !enableMissingValueComponent ? "<Not needed>" : "", className: !enableMissingValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: function (value) { return setMissingValueReplacement(value); }, onBlur: handleSave }) })) })] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Invalid Value Treatment Method", fieldId: "invalidValueTreatment" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: "invalidValueTreatment", items: ["", "returnInvalid", "asIs", "asMissing", "asValue"], onSelect: function (selection) {
                                                                setInvalidValueTreatment(selection);
                                                                setSubmitChanges(true);
                                                            }, selection: invalidValueTreatment }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Invalid Value Replacement", fieldId: "invalidValueReplacement", validated: validationsInvalidValueReplacement.length === 0 ? "default" : "warning", helperText: validationsInvalidValueReplacement[0] ? validationsInvalidValueReplacement[0].message : "", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Invalid Value Replacement is required when Invalid Value Treatment is \"asValue\"" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Invalid Value Replacement field", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "invalidValueReplacement", name: "invalidValueReplacement", "aria-describedby": "Invalid Value Replacement", value: invalidValueReplacement, validated: validationsInvalidValueReplacement.length === 0 ? "default" : "warning", isDisabled: !enableInvalidValueComponent, placeholder: !enableInvalidValueComponent ? "<Not needed>" : "", className: !enableInvalidValueComponent ? "mining-schema__edit__form__disabled" : "", onChange: function (value) { return setInvalidValueReplacement(value); }, onBlur: handleSave }) })) })] })) })] })) }) })), (0, jsx_runtime_1.jsx)("section", __assign({ className: "mining-schema__edit__actions" }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: onClose, icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_left_icon_1.ArrowAltCircleLeftIcon, {}), iconPosition: "left", ouiaId: "back-to-ms-overview" }, { children: "Back" })) }))] })] })));
};
exports.default = MiningSchemaPropertiesEdit;
//# sourceMappingURL=MiningSchemaPropertiesEdit.js.map