"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Modal_1 = require("@patternfly/react-core/dist/js/components/Modal");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var close_icon_1 = require("@patternfly/react-icons/dist/js/icons/close-icon");
var warning_triangle_icon_1 = require("@patternfly/react-icons/dist/js/icons/warning-triangle-icon");
var MiningSchemaContainer_1 = require("../MiningSchemaContainer/MiningSchemaContainer");
var react_redux_1 = require("react-redux");
var reducers_1 = require("../../../reducers");
var history_1 = require("../../../history");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var MiningSchemaHandler = function (props) {
    var miningSchema = props.miningSchema, modelIndex = props.modelIndex;
    var _a = __read((0, react_1.useState)(false), 2), isMiningSchemaOpen = _a[0], setIsMiningSchemaOpen = _a[1];
    var dataDictionary = (0, react_redux_1.useSelector)(function (state) { return state.DataDictionary; });
    var _b = (0, history_1.useHistoryService)(), service = _b.service, getCurrentState = _b.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var addMiningField = function (names) {
        dispatch({
            type: reducers_1.Actions.AddMiningSchemaFields,
            payload: {
                modelIndex: modelIndex,
                names: names,
            },
        });
    };
    var deleteMiningField = function (index) {
        dispatch({
            type: reducers_1.Actions.DeleteMiningSchemaField,
            payload: {
                modelIndex: modelIndex,
                miningSchemaIndex: index,
                name: miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[index].name,
            },
        });
    };
    var updateField = function (index, originalName, field) {
        dispatch({
            type: reducers_1.Actions.UpdateMiningSchemaField,
            payload: __assign(__assign({ modelIndex: modelIndex, miningSchemaIndex: index }, field), { originalName: originalName }),
        });
    };
    var handleMiningSchemaToggle = function () {
        setIsMiningSchemaOpen(!isMiningSchemaOpen);
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().build()); }, [modelIndex, miningSchema, dataDictionary]);
    var header = ((0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h1", size: Title_1.TitleSizes["2xl"] }, { children: "Mining Schema" })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ type: "button", variant: Button_1.ButtonVariant.plain, onClick: handleMiningSchemaToggle, "data-title": "MiningSchemaModalClose", ouiaId: "editor-close" }, { children: (0, jsx_runtime_1.jsx)(close_icon_1.CloseIcon, {}) })) })] })));
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length === 0 && ((0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: handleMiningSchemaToggle, "data-title": "MiningSchema", ouiaId: "open-mining-schema-editor" }, { children: "Set Mining Schema" }))), validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorTooltip, __assign({ validations: validations }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", icon: (0, jsx_runtime_1.jsx)(warning_triangle_icon_1.WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: handleMiningSchemaToggle, "data-title": "MiningSchema", ouiaId: "open-mining-schema-editor" }, { children: "Set Mining Schema" })) }))), (0, jsx_runtime_1.jsx)(Modal_1.Modal, __assign({ "aria-label": "mining-schema", title: "Mining Schema", header: header, isOpen: isMiningSchemaOpen, showClose: false, variant: Modal_1.ModalVariant.large, onEscapePress: function () { return false; }, "data-title": "MiningSchemaModal", ouiaId: "mining-schema-editor" }, { children: (0, jsx_runtime_1.jsx)(MiningSchemaContainer_1.default, { modelIndex: modelIndex, miningSchema: miningSchema, dataDictionary: dataDictionary, onAddField: addMiningField, onDeleteField: deleteMiningField, onUpdateField: updateField }) }))] }));
};
exports.default = MiningSchemaHandler;
//# sourceMappingURL=MiningSchemaHandler.js.map