"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeLabels = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var validation_1 = require("../../../validation");
var AttributeLabel_1 = require("./AttributeLabel");
var atoms_1 = require("../../EditorCore/atoms");
var paths_1 = require("../../../paths");
var AttributeLabels = function (props) {
    var modelIndex = props.modelIndex, characteristic = props.characteristic, characteristicIndex = props.characteristicIndex, activeAttributeIndex = props.activeAttributeIndex, activeAttribute = props.activeAttribute, areReasonCodesUsed = props.areReasonCodesUsed, characteristicReasonCode = props.characteristicReasonCode, commit = props.commit;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var reasonCodeValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(activeAttributeIndex)
            .forReasonCode()
            .build());
    }, [
        modelIndex,
        characteristicIndex,
        areReasonCodesUsed,
        activeAttribute,
        activeAttributeIndex,
        characteristicReasonCode,
    ]);
    var partialScoreValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(activeAttributeIndex)
            .forPartialScore()
            .build());
    }, [modelIndex, characteristicIndex, characteristic, activeAttribute, activeAttributeIndex]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [areReasonCodesUsed && activeAttribute.reasonCode !== undefined && reasonCodeValidation.length === 0 && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [commit && ((0, jsx_runtime_1.jsx)(AttributeLabel_1.AttributeLabel, { name: "Reason code", value: activeAttribute.reasonCode, onClose: function () { return commit({ reasonCode: undefined }); } })), !commit && (0, jsx_runtime_1.jsx)(AttributeLabel_1.AttributeLabel, { name: "Reason code", value: activeAttribute.reasonCode })] })), areReasonCodesUsed && reasonCodeValidation.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: reasonCodeValidation, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Reason code:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }) }))), partialScoreValidation.length === 0 && activeAttribute.partialScore !== undefined && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [commit && ((0, jsx_runtime_1.jsx)(AttributeLabel_1.AttributeLabel, { name: "Partial score", value: activeAttribute.partialScore, onClose: function () { return commit({ partialScore: undefined }); } })), !commit && (0, jsx_runtime_1.jsx)(AttributeLabel_1.AttributeLabel, { name: "Partial score", value: activeAttribute.partialScore })] })), partialScoreValidation.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: partialScoreValidation, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Partial score:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }) })))] }));
};
exports.AttributeLabels = AttributeLabels;
//# sourceMappingURL=AttributeLabels.js.map