"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidationIndicatorLabel = exports.ValidationIndicatorTooltip = exports.ValidationIndicator = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var exclamation_circle_icon_1 = require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon");
var exclamation_triangle_icon_1 = require("@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon");
require("./ModelTitle.scss");
var validation_1 = require("../../../validation");
var ValidationIndicator = function (props) {
    var validations = props.validations;
    var maxLevel = (0, react_1.useMemo)(function () { return getMaxLevel(validations); }, [validations]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: maxLevel !== undefined && ((0, jsx_runtime_1.jsx)(exports.ValidationIndicatorTooltip, __assign({ validations: validations }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [maxLevel === validation_1.ValidationLevel.ERROR && (0, jsx_runtime_1.jsx)(exclamation_circle_icon_1.ExclamationCircleIcon, { size: "sm", color: "red" }), maxLevel === validation_1.ValidationLevel.WARNING && (0, jsx_runtime_1.jsx)(exclamation_triangle_icon_1.ExclamationTriangleIcon, { size: "sm", color: "orange" })] }) }))) }));
};
exports.ValidationIndicator = ValidationIndicator;
var ValidationIndicatorTooltip = function (props) {
    var validations = props.validations, children = props.children, customTooltipContent = props.customTooltipContent;
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: validations.length > 0 && ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ maxWidth: "100%", isContentLeftAligned: true, content: customTooltipContent ? customTooltipContent : list(validations) }, { children: children }))) }));
};
exports.ValidationIndicatorTooltip = ValidationIndicatorTooltip;
var ValidationIndicatorLabel = function (props) {
    var validations = props.validations, children = props.children, customTooltipContent = props.customTooltipContent, onClose = props.onClose, cssClass = props.cssClass;
    var maxLevel = (0, react_1.useMemo)(function () { return getMaxLevel(validations); }, [validations]);
    var labelColor = (0, react_1.useMemo)(function () {
        switch (maxLevel) {
            case validation_1.ValidationLevel.ERROR:
                return "red";
            case validation_1.ValidationLevel.WARNING:
                return "orange";
            default:
                return "orange";
        }
    }, [maxLevel]);
    var labelIcon = (0, react_1.useMemo)(function () {
        switch (maxLevel) {
            case validation_1.ValidationLevel.ERROR:
                return (0, jsx_runtime_1.jsx)(exclamation_circle_icon_1.ExclamationCircleIcon, { size: "sm", color: "red" });
            case validation_1.ValidationLevel.WARNING:
                return (0, jsx_runtime_1.jsx)(exclamation_triangle_icon_1.ExclamationTriangleIcon, { size: "sm", color: "orange" });
            default:
                return undefined;
        }
    }, [maxLevel]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: maxLevel !== undefined && ((0, jsx_runtime_1.jsx)(exports.ValidationIndicatorTooltip, __assign({ validations: validations, customTooltipContent: customTooltipContent }, { children: (0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ onClose: onClose, className: cssClass, color: labelColor, icon: labelIcon, "data-ouia-component-type": "invalid-label" }, { children: children })) }))) }));
};
exports.ValidationIndicatorLabel = ValidationIndicatorLabel;
var getMaxLevel = function (validations) {
    if (validations.length === 0) {
        return undefined;
    }
    return validations.reduce(function (pv, cv) {
        if (pv.level < cv.level) {
            return cv;
        }
        if (pv.level > cv.level) {
            return pv;
        }
        return cv;
    }).level;
};
var list = function (validations) {
    return ((0, jsx_runtime_1.jsx)("ol", { children: validations.map(function (validation, index) { return ((0, jsx_runtime_1.jsx)("li", { children: validation.message }, index)); }) }));
};
//# sourceMappingURL=ValidationIndicator.js.map