"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelTitle = exports.MODEL_NAME_NOT_SET = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
require("./ModelTitle.scss");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var EditorScorecard_1 = require("../../EditorScorecard");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
exports.MODEL_NAME_NOT_SET = "<Model Name not set>";
var ModelTitle = function (props) {
    var modelName = props.modelName, commitModelName = props.commitModelName;
    var _a = __read((0, react_1.useState)(false), 2), isEditing = _a[0], setEditing = _a[1];
    var _b = __read((0, react_1.useState)(""), 2), title = _b[0], setTitle = _b[1];
    var _c = (0, EditorScorecard_1.useOperation)(), activeOperation = _c.activeOperation, setActiveOperation = _c.setActiveOperation;
    var ref = (0, react_cool_onclickoutside_1.default)(function (event) { return onCommitAndClose(); }, {
        disabled: activeOperation !== EditorScorecard_1.Operation.UPDATE_NAME,
        eventTypes: ["click"],
    });
    (0, react_1.useEffect)(function () {
        setTitle(modelName);
    }, [modelName]);
    var onEdit = function () {
        if (commitModelName !== undefined) {
            setEditing(true);
            setActiveOperation(EditorScorecard_1.Operation.UPDATE_NAME);
        }
    };
    var onCommitAndClose = function () {
        onCommit();
        onCancel();
    };
    var onCommit = function () {
        if (commitModelName !== undefined) {
            commitModelName(title);
        }
    };
    var onCancel = function () {
        setEditing(false);
        setActiveOperation(EditorScorecard_1.Operation.NONE);
    };
    var isEditModeEnabled = (0, react_1.useMemo)(function () { return isEditing && activeOperation === EditorScorecard_1.Operation.UPDATE_NAME; }, [isEditing, activeOperation]);
    var modelTitleClassNames = (0, react_1.useMemo)(function () {
        return "".concat(commitModelName !== undefined ? "modelTitle" : "modelTitle modelTitle--editing", " pf-c-title pf-m-2xl pf-c-form-control");
    }, [commitModelName]);
    return ((0, jsx_runtime_1.jsx)("div", __assign({ ref: ref, onKeyDown: function (e) {
            if (e.key === "Enter") {
                onEdit();
            }
            else if (e.key === "Escape") {
                setTitle(modelName);
                onCancel();
            }
        } }, { children: (0, jsx_runtime_1.jsx)("div", __assign({ className: "modelTitle--full-width" }, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, __assign({ id: "modelTitle-form", onSubmit: function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                } }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, className: "modelTitle--hide-overflow" }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ className: "modelTitle__icon" }, { children: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "The Model Name will be generated at runtime if not set." }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info about Model Name", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help modelTitle__icon" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true, className: "modelTitle--hide-overflow" }, { children: (0, jsx_runtime_1.jsxs)(Form_1.FormGroup, __assign({ fieldId: "modelName" }, { children: [!isEditModeEnabled && ((0, jsx_runtime_1.jsxs)("div", __assign({ className: modelTitleClassNames, onClick: onEdit, "data-ouia-component-id": "model-name" }, { children: [modelName.trim() !== "" && (0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ className: "modelTitle__truncate" }, { children: modelName })), modelName.trim() === "" && ((0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ className: "modelTitle__truncate modelTitle__truncate--disabled" }, { children: exports.MODEL_NAME_NOT_SET })))] }))), isEditModeEnabled && ((0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "modelName", name: "modelName", "aria-describedby": "modelName ", className: "".concat(modelTitleClassNames, " modelTitle--editing"), autoFocus: true, value: title, placeholder: exports.MODEL_NAME_NOT_SET, onChange: setTitle, onBlur: onCommitAndClose, ouiaId: "set-model-name" }))] })) }))] })) })) })) })));
};
exports.ModelTitle = ModelTitle;
//# sourceMappingURL=ModelTitle.js.map