"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PMMLEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = require("react");
var immer_1 = require("immer");
var redux_1 = require("redux");
var reducers_1 = require("./reducers");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var react_redux_1 = require("react-redux");
var combine_reducer_1 = require("combine-reducer");
var history_1 = require("./history");
var templates_1 = require("./components/LandingPage/templates");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var react_router_dom_1 = require("react-router-dom");
var react_router_1 = require("react-router");
var organisms_1 = require("./components/LandingPage/organisms");
var organisms_2 = require("./components/EditorCore/organisms");
var PMMLModelHelper_1 = require("./PMMLModelHelper");
var EditorScorecard_1 = require("./components/EditorScorecard");
var validation_1 = require("./validation");
var api_1 = require("@kie-tools-core/workspace/dist/api");
var paths_1 = require("./paths");
var EMPTY_PMML = "<PMML xmlns=\"http://www.dmg.org/PMML-4_4\" version=\"4.4\"><Header /><DataDictionary/></PMML>";
var PMMLEditor = (function (_super) {
    __extends(PMMLEditor, _super);
    function PMMLEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.history = new history_1.HistoryService([
            function (id) {
                _this.props.newEdit(new api_1.WorkspaceEdit(id));
            },
            function () {
                _this.props.setNotifications(_this.state.path, _this.validate());
            },
        ]);
        _this.validationRegistry = new validation_1.ValidationRegistry();
        props.exposing(_this);
        _this.state = {
            path: "",
            content: "",
            originalContent: "",
            activeOperation: EditorScorecard_1.Operation.NONE,
        };
        (0, immer_1.enableMapSet)();
        (0, immer_1.enablePatches)();
        _this.reducer = (0, combine_reducer_1.default)((0, reducers_1.PMMLReducer)(_this.history, _this.validationRegistry), {
            Header: (0, reducers_1.HeaderReducer)(_this.history),
            DataDictionary: (0, combine_reducer_1.default)((0, reducers_1.DataDictionaryReducer)(_this.history, _this.validationRegistry), {
                DataField: (0, reducers_1.DataDictionaryFieldReducer)(_this.history, _this.validationRegistry),
            }),
            models: (0, reducers_1.ModelReducer)(_this.history, _this.validationRegistry),
        });
        return _this;
    }
    PMMLEditor.prototype.componentDidMount = function () {
        this.props.ready();
    };
    PMMLEditor.prototype.setContent = function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        try {
            this.doSetContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
            this.props.setNotifications(this.state.path, this.validate());
            return Promise.resolve();
        }
        catch (e) {
            console.error(e);
            return Promise.reject();
        }
    };
    PMMLEditor.prototype.doSetContent = function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        var _a;
        var pmml;
        var _content = content;
        if (content === "") {
            _content = EMPTY_PMML;
            pmml = (0, pmml_editor_marshaller_1.XML2PMML)(_content);
            var supportedEditorTypes = PMMLModelHelper_1.PMMLModels.filter(function (m) { return m.capability === PMMLModelHelper_1.SupportedCapability.EDITOR; });
            if (content === "" && supportedEditorTypes.length === 1) {
                var factory = supportedEditorTypes[0].factory;
                if (factory) {
                    pmml.models = [factory()];
                }
            }
        }
        else {
            pmml = (0, pmml_editor_marshaller_1.XML2PMML)(_content);
        }
        this.store = (0, redux_1.createStore)(this.reducer, pmml);
        (_a = this.store) === null || _a === void 0 ? void 0 : _a.dispatch({
            type: reducers_1.Actions.Validate,
            payload: {},
        });
        this.setState({
            path: normalizedPosixPathRelativeToTheWorkspaceRoot,
            content: _content,
            originalContent: _content,
            activeOperation: EditorScorecard_1.Operation.NONE,
        });
    };
    PMMLEditor.prototype.getContent = function () {
        return Promise.resolve(this.doGetContent());
    };
    PMMLEditor.prototype.doGetContent = function () {
        var _a;
        var pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        return pmml ? (0, pmml_editor_marshaller_1.PMML2XML)(pmml) : "";
    };
    PMMLEditor.prototype.undo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, Promise.resolve(this.doUndo())];
            });
        });
    };
    PMMLEditor.prototype.doUndo = function () {
        var _a, _b, _c;
        var pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        if (pmml !== undefined) {
            (_b = this.store) === null || _b === void 0 ? void 0 : _b.dispatch({
                type: reducers_1.Actions.Undo,
                payload: undefined,
            });
            (_c = this.store) === null || _c === void 0 ? void 0 : _c.dispatch({
                type: reducers_1.Actions.Validate,
                payload: {},
            });
            this.props.setNotifications(this.state.path, this.validate());
        }
    };
    PMMLEditor.prototype.redo = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, Promise.resolve(this.doRedo())];
            });
        });
    };
    PMMLEditor.prototype.doRedo = function () {
        var _a, _b, _c;
        var pmml = (_a = this.store) === null || _a === void 0 ? void 0 : _a.getState();
        if (pmml !== undefined) {
            (_b = this.store) === null || _b === void 0 ? void 0 : _b.dispatch({
                type: reducers_1.Actions.Redo,
                payload: undefined,
            });
            (_c = this.store) === null || _c === void 0 ? void 0 : _c.dispatch({
                type: reducers_1.Actions.Validate,
                payload: {},
            });
            this.props.setNotifications(this.state.path, this.validate());
        }
    };
    PMMLEditor.prototype.validate = function () {
        return (0, validation_1.toNotifications)(this.state.path, this.validationRegistry.get((0, paths_1.Builder)().build()));
    };
    PMMLEditor.prototype.isSingleModel = function () {
        if (!this.store) {
            return false;
        }
        var models = this.store.getState().models;
        if (models !== undefined) {
            if (models.length === 1) {
                return true;
            }
        }
        return false;
    };
    PMMLEditor.prototype.render = function () {
        var _this = this;
        var isSingleModel = this.isSingleModel();
        if (this.store) {
            var path = this.state.path;
            return ((0, jsx_runtime_1.jsx)(react_router_dom_1.HashRouter, { children: (0, jsx_runtime_1.jsx)(Page_1.Page, { children: (0, jsx_runtime_1.jsx)(react_redux_1.Provider, __assign({ store: this.store }, { children: (0, jsx_runtime_1.jsx)(validation_1.ValidationContext.Provider, __assign({ value: { validationRegistry: this.validationRegistry } }, { children: (0, jsx_runtime_1.jsx)(history_1.HistoryContext.Provider, __assign({ value: {
                                    service: this.history,
                                    getCurrentState: function () { var _a; return (_a = _this.store) === null || _a === void 0 ? void 0 : _a.getState(); },
                                } }, { children: (0, jsx_runtime_1.jsxs)(react_router_1.Switch, { children: [(0, jsx_runtime_1.jsxs)(react_router_1.Route, __assign({ exact: true, path: "/" }, { children: [!isSingleModel && (0, jsx_runtime_1.jsx)(templates_1.LandingPage, { path: path }), isSingleModel && (0, jsx_runtime_1.jsx)(react_router_1.Redirect, { from: "/", to: "/editor/0" })] })), (0, jsx_runtime_1.jsx)(react_router_1.Route, __assign({ exact: true, path: "/editor/:index" }, { children: (0, jsx_runtime_1.jsx)(EditorScorecard_1.OperationContext.Provider, __assign({ value: {
                                                    activeOperation: this.state.activeOperation,
                                                    setActiveOperation: function (operation) {
                                                        return _this.setState(__assign(__assign({}, _this.state), { activeOperation: operation }));
                                                    },
                                                } }, { children: (0, jsx_runtime_1.jsx)(organisms_2.SingleEditorRouter, { path: path }) })) }))] }) })) })) })) }) }));
        }
        else {
            return (0, jsx_runtime_1.jsx)(organisms_1.EmptyStateNoContent, {});
        }
    };
    return PMMLEditor;
}(React.Component));
exports.PMMLEditor = PMMLEditor;
//# sourceMappingURL=PMMLEditor.js.map