import { EditorContent } from "./EditorContent";
import { KeyboardShortcutsEnvelopeApi } from "@kie-tools-core/keyboard-shortcuts/dist/api";
import { I18nEnvelopeApi } from "@kie-tools-core/i18n/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
export interface Association {
    origin: string;
    envelopeServerId: string;
}
export declare enum ChannelType {
    VSCODE_DESKTOP = "VSCODE_DESKTOP",
    VSCODE_WEB = "VSCODE_WEB",
    ONLINE = "ONLINE",
    GITHUB = "GITHUB",
    EMBEDDED = "EMBEDDED",
    OTHER = "OTHER",
    ONLINE_MULTI_FILE = "ONLINE_MULTI_FILE",
    STANDALONE = "STANDALONE"
}
export declare const DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH = "/";
export interface EditorInitArgs {
    resourcesPathPrefix: string;
    fileExtension: string;
    initialLocale: string;
    isReadOnly: boolean;
    channel: ChannelType;
    workspaceRootAbsolutePosixPath: string;
}
export interface KogitoEditorEnvelopeApi extends KeyboardShortcutsEnvelopeApi, I18nEnvelopeApi {
    kogitoEditor_contentChanged(content: EditorContent, args: {
        showLoadingOverlay: boolean;
    }): Promise<void>;
    kogitoEditor_editorUndo(): void;
    kogitoEditor_editorRedo(): void;
    kogitoEditor_initRequest(association: Association, editorInit: EditorInitArgs): Promise<void>;
    kogitoEditor_contentRequest(): Promise<EditorContent>;
    kogitoEditor_previewRequest(): Promise<string>;
    kogitoEditor_validate(): Promise<Notification[]>;
}
//# sourceMappingURL=KogitoEditorEnvelopeApi.d.ts.map