export declare const YARD_SCHEMA: {
    $id: string;
    $schema: string;
    definitions: {
        "DecisionTable-1": {
            type: string;
            properties: {
                inputs: {
                    type: string;
                    items: {
                        type: string;
                    };
                };
                hitPolicy: {
                    type: string;
                    default: string;
                };
                rules: {
                    type: string;
                    items: {
                        anyOf: {
                            $ref: string;
                        }[];
                    };
                };
                outputComponents: {
                    description: string;
                    type: string;
                    items: {
                        type: string;
                    };
                };
            };
            required: string[];
        };
        "DecisionTable-2": {
            allOf: ({
                $ref: string;
                type?: undefined;
                properties?: undefined;
                required?: undefined;
            } | {
                type: string;
                properties: {
                    type: {
                        const: string;
                    };
                };
                required: string[];
                $ref?: undefined;
            })[];
        };
        Element: {
            type: string;
            properties: {
                name: {
                    type: string;
                };
                type: {
                    type: string;
                };
                requirements: {
                    type: string;
                    items: {
                        type: string;
                    };
                };
                logic: {
                    anyOf: {
                        $ref: string;
                    }[];
                };
            };
            required: string[];
        };
        InlineRule: {
            type: string;
            items: {};
        };
        Input: {
            type: string;
            properties: {
                name: {
                    type: string;
                };
                type: {
                    type: string;
                };
            };
            required: string[];
        };
        "LiteralExpression-1": {
            type: string;
            properties: {
                expression: {
                    type: string;
                };
            };
            required: string[];
        };
        "LiteralExpression-2": {
            allOf: ({
                $ref: string;
                type?: undefined;
                properties?: undefined;
                required?: undefined;
            } | {
                type: string;
                properties: {
                    type: {
                        const: string;
                    };
                };
                required: string[];
                $ref?: undefined;
            })[];
        };
        WhenThenRule: {
            type: string;
            properties: {
                when: {
                    type: string;
                    items: {};
                };
                then: {};
            };
            required: string[];
        };
    };
    type: string;
    properties: {
        specVersion: {
            type: string;
            default: string;
        };
        kind: {
            type: string;
            default: string;
        };
        name: {
            type: string;
            description: string;
        };
        expressionLang: {
            type: string;
            description: string;
        };
        inputs: {
            type: string;
            items: {
                $ref: string;
            };
        };
        elements: {
            type: string;
            items: {
                $ref: string;
            };
        };
    };
    required: string[];
};
//# sourceMappingURL=yard.d.ts.map