"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useWorkspaces = exports.WorkspacesContext = exports.WorkspaceFile = void 0;
var react_1 = require("react");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var WorkspaceFileRelativePathParser_1 = require("../relativePath/WorkspaceFileRelativePathParser");
var WorkspaceFile = (function () {
    function WorkspaceFile(args) {
        this.args = args;
        this.parsedRelativePath = (0, WorkspaceFileRelativePathParser_1.parseWorkspaceFileRelativePath)(this.relativePath);
    }
    Object.defineProperty(WorkspaceFile.prototype, "getFileContentsAsString", {
        get: function () {
            var _this = this;
            return function () { return _this.getFileContents().then(function (c) { return EncoderDecoder_1.decoder.decode(c); }); };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "getFileContents", {
        get: function () {
            return this.args.getFileContents;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "workspaceId", {
        get: function () {
            return this.args.workspaceId;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "relativePath", {
        get: function () {
            return this.args.relativePath;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "relativePathWithoutExtension", {
        get: function () {
            return this.parsedRelativePath.relativePathWithoutExtension;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "relativeDirPath", {
        get: function () {
            return this.parsedRelativePath.relativeDirPath;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "extension", {
        get: function () {
            return this.parsedRelativePath.extension;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "nameWithoutExtension", {
        get: function () {
            return this.parsedRelativePath.nameWithoutExtension;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(WorkspaceFile.prototype, "name", {
        get: function () {
            return this.parsedRelativePath.name;
        },
        enumerable: false,
        configurable: true
    });
    return WorkspaceFile;
}());
exports.WorkspaceFile = WorkspaceFile;
exports.WorkspacesContext = (0, react_1.createContext)({});
function useWorkspaces() {
    return (0, react_1.useContext)(exports.WorkspacesContext);
}
exports.useWorkspaces = useWorkspaces;
//# sourceMappingURL=WorkspacesContext.js.map