export function buildXmlHref(_a) {
    var namespace = _a.namespace, id = _a.id;
    return "".concat(namespace !== null && namespace !== void 0 ? namespace : "", "#").concat(id);
}
export function parseXmlHref(href) {
    var split = href.split("#");
    if (split.length <= 1) {
        return { namespace: undefined, id: split[0] };
    }
    if (split.length > 2) {
        throw new Error("XML URI can't have hashes (#) on neither the namespace or the id. Alledged URI: '".concat(href, "'"));
    }
    return { namespace: split[0] ? split[0] : undefined, id: split[1] };
}
export function addNamespaceToHref(_a) {
    var href = _a.href, namespace = _a.namespace;
    if (namespace === undefined) {
        return href;
    }
    var _b = parseXmlHref(href), hrefNamespace = _b.namespace, id = _b.id;
    if (hrefNamespace !== undefined) {
        return href;
    }
    return buildXmlHref({ namespace: namespace, id: id });
}
//# sourceMappingURL=xmlHrefs.js.map