import * as RF from "reactflow";
import { NodeType } from "../../diagram/connections/graphStructure";
import { DmnDiagramEdgeData } from "../../diagram/edges/Edges";
import { DrgEdge, DrgAdjacencyList } from "../../diagram/graph/graph";
import { DmnDiagramNodeData, NodeDmnObjects } from "../../diagram/nodes/Nodes";
import { TypeOrReturnType } from "../ComputedStateCache";
import { Computed, State } from "../Store";
export declare const NODE_LAYERS: {
    GROUP_NODE: number;
    NODES: number;
    DECISION_SERVICE_NODE: number;
    NESTED_NODES: number;
};
export declare function computeDiagramData(diagram: State["diagram"], definitions: State["dmn"]["model"]["definitions"], externalModelTypesByNamespace: TypeOrReturnType<Computed["getExternalModelTypesByNamespace"]>, indexedDrd: TypeOrReturnType<Computed["indexedDrd"]>, isAlternativeInputDataShape: boolean): {
    drgEdges: DrgEdge[];
    drgAdjacencyList: DrgAdjacencyList;
    nodes: RF.Node<DmnDiagramNodeData<NodeDmnObjects>, string | undefined>[];
    edges: RF.Edge<DmnDiagramEdgeData>[];
    edgesById: Map<string, RF.Edge<DmnDiagramEdgeData>>;
    externalNodesByNamespace: Map<string, RF.Node<DmnDiagramNodeData<NodeDmnObjects>, string | undefined>[]>;
    edgesFromExternalNodesByNamespace: Map<string, RF.Edge<DmnDiagramEdgeData>[]>;
    nodesById: Map<string, RF.Node<DmnDiagramNodeData<NodeDmnObjects>, string | undefined>>;
    selectedNodeTypes: Set<NodeType>;
    selectedNodesById: Map<string, RF.Node<DmnDiagramNodeData<NodeDmnObjects>, string | undefined>>;
    selectedEdgesById: Map<string, RF.Edge<DmnDiagramEdgeData>>;
    drgElementsWithoutVisualRepresentationOnCurrentDrd: string[];
};
export declare function assignClassesToHighlightedHierarchyNodes(selected: string[], nodesById: Map<string, RF.Node>, edgesById: Map<string, RF.Edge>, drgEdges: DrgEdge[]): void;
//# sourceMappingURL=computeDiagramData.d.ts.map