var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { useDmnEditorStore } from "../store/StoreContext";
import { useMemo } from "react";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { useDmnEditor } from "../DmnEditorContext";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function UnknownProperties(props) {
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var externalDmnsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace).dmns; });
    var onRequestToJumpToPath = useDmnEditor().onRequestToJumpToPath;
    var content = useMemo(function () {
        var _a;
        var namespace = thisDmn.model.definitions["@_xmlns:".concat(props.dmnElementRefQName.prefix)];
        if (!namespace) {
            return _jsx("p", { children: "This node references an external node with a namespace that is not declared at this DMN." });
        }
        var externalDmn = externalDmnsByNamespace.get(namespace);
        if (!externalDmn) {
            return (_jsx("p", { children: "This node references an external node from a namespace that is not provided on this DMN's external DMNs mapping. " }));
        }
        var externalDrgElementsById = ((_a = externalDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).reduce(function (acc, e, index) { return acc.set(e["@_id"], { element: e, index: index }); }, new Map());
        var externalDrgElement = externalDrgElementsById.get(props.dmnElementRefQName.localPart);
        if (!externalDrgElement) {
            return (_jsxs(_Fragment, { children: [_jsx("p", { children: "This node references a DRG element from '".concat(externalDmn.model.definitions["@_name"], "' that doesn't exist.") }), onRequestToJumpToPath && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx(Button, __assign({ style: { paddingLeft: 0 }, variant: ButtonVariant.link, onClick: function () { return onRequestToJumpToPath === null || onRequestToJumpToPath === void 0 ? void 0 : onRequestToJumpToPath(externalDmn.normalizedPosixPathRelativeToTheOpenFile); } }, { children: "Go to '".concat(externalDmn.model.definitions["@_name"], "'") }))] }))] }));
        }
    }, [
        externalDmnsByNamespace,
        onRequestToJumpToPath,
        props.dmnElementRefQName.localPart,
        props.dmnElementRefQName.prefix,
        thisDmn.model.definitions,
    ]);
    return (_jsx(_Fragment, { children: _jsxs(Alert, __assign({ title: "This is a placeholder for an unknown node", isInline: true, variant: AlertVariant.danger }, { children: [_jsx("br", {}), content, _jsx(Divider, { style: { marginTop: "16px" } }), _jsx("br", {}), _jsxs("p", { children: [_jsx("b", { children: "Reference:" }), "\u00A0", "".concat(buildXmlQName(props.dmnElementRefQName))] })] })) }));
}
//# sourceMappingURL=UnknownProperties.js.map