var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { Fragment as _Fragment, jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { useState } from "react";
import { Form, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { FontOptions } from "./FontOptions";
import { ShapeOptions } from "./ShapeOptions";
import { InputDataProperties } from "./InputDataProperties";
import { DecisionProperties } from "./DecisionProperties";
import { BkmProperties } from "./BkmProperties";
import { DecisionServiceProperties } from "./DecisionServiceProperties";
import { KnowledgeSourceProperties } from "./KnowledgeSourceProperties";
import { TextAnnotationProperties } from "./TextAnnotationProperties";
import { useMemo } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { NodeIcon } from "../icons/Icons";
import { GroupProperties } from "./GroupProperties";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import { UnknownProperties } from "./UnknownProperties";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import "./SingleNodeProperties.css";
export function SingleNodeProperties(_a) {
    var nodeId = _a.nodeId;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var node = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).nodesById.get(nodeId); });
    var _b = __read(useState(true), 2), isSectionExpanded = _b[0], setSectionExpanded = _b[1];
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var nodeIds = useMemo(function () { return ((node === null || node === void 0 ? void 0 : node.id) ? [node.id] : []); }, [node === null || node === void 0 ? void 0 : node.id]);
    var Icon = useMemo(function () {
        var _a;
        if (((_a = node === null || node === void 0 ? void 0 : node.data) === null || _a === void 0 ? void 0 : _a.dmnObject) === undefined) {
            throw new Error("Icon can't be defined without a DMN object");
        }
        var nodeType = getNodeTypeFromDmnObject(node.data.dmnObject);
        if (nodeType === undefined) {
            throw new Error("Can't determine node icon with undefined node type");
        }
        return NodeIcon({ nodeType: nodeType, isAlternativeInputDataShape: isAlternativeInputDataShape });
    }, [isAlternativeInputDataShape, node === null || node === void 0 ? void 0 : node.data.dmnObject]);
    if (!node) {
        return _jsxs(_Fragment, { children: ["Node not found: ", nodeId] });
    }
    return (_jsx(Form, { children: _jsxs(FormSection, __assign({ className: !isSectionExpanded ? "kie-dmn-editor--single-node-properties-title-colapsed" : "", title: _jsx(PropertiesPanelHeader, { expands: true, fixed: true, isSectionExpanded: isSectionExpanded, toogleSectionExpanded: function () { return setSectionExpanded(function (prev) { return !prev; }); }, icon: _jsx(Icon, {}), title: (function () {
                    switch (node.type) {
                        case NODE_TYPES.inputData:
                            return "Input";
                        case NODE_TYPES.decision:
                            return "Decision";
                        case NODE_TYPES.bkm:
                            return "Business Knowledge Model";
                        case NODE_TYPES.decisionService:
                            return "Decision Service";
                        case NODE_TYPES.knowledgeSource:
                            return "Knowledge Source";
                        case NODE_TYPES.textAnnotation:
                            return "Text Annotation";
                        case NODE_TYPES.group:
                            return "Group";
                        case NODE_TYPES.unknown:
                            return _jsx(_Fragment, { children: "Unknown" });
                        default:
                            throw new Error("Unknown type of node ".concat(node.type));
                    }
                })(), action: _jsx(Button, __assign({ title: "Close", variant: ButtonVariant.plain, onClick: function () {
                        dmnEditorStoreApi.setState(function (state) {
                            state.boxedExpressionEditor.propertiesPanel.isOpen = false;
                            state.diagram.propertiesPanel.isOpen = false;
                        });
                    } }, { children: _jsx(TimesIcon, {}) })) }) }, { children: [isSectionExpanded && (_jsx(_Fragment, { children: _jsx(FormSection, __assign({ style: { paddingLeft: "20px" } }, { children: (function () {
                            switch (node.type) {
                                case NODE_TYPES.inputData:
                                    return (_jsx(InputDataProperties, { inputData: node.data.dmnObject, namespace: node.data.dmnObjectNamespace, index: node.data.index }));
                                case NODE_TYPES.decision:
                                    return (_jsx(DecisionProperties, { decision: node.data.dmnObject, namespace: node.data.dmnObjectNamespace, index: node.data.index }));
                                case NODE_TYPES.bkm:
                                    return (_jsx(BkmProperties, { bkm: node.data.dmnObject, namespace: node.data.dmnObjectNamespace, index: node.data.index }));
                                case NODE_TYPES.decisionService:
                                    return (_jsx(DecisionServiceProperties, { decisionService: node.data.dmnObject, namespace: node.data.dmnObjectNamespace, index: node.data.index }));
                                case NODE_TYPES.knowledgeSource:
                                    return (_jsx(KnowledgeSourceProperties, { knowledgeSource: node.data.dmnObject, namespace: node.data.dmnObjectNamespace, index: node.data.index }));
                                case NODE_TYPES.textAnnotation:
                                    return (_jsx(TextAnnotationProperties, { textAnnotation: node.data.dmnObject, index: node.data.index }));
                                case NODE_TYPES.group:
                                    return (_jsx(GroupProperties, { group: node.data.dmnObject, index: node.data.index }));
                                case NODE_TYPES.unknown:
                                    return _jsx(UnknownProperties, { shape: node.data.shape, dmnElementRefQName: node.data.dmnObjectQName });
                                default:
                                    throw new Error("Unknown type of node ".concat(node === null || node === void 0 ? void 0 : node.__$$element));
                            }
                        })() })) })), _jsx(FontOptions, { startExpanded: false, nodeIds: nodeIds }), _jsx(ShapeOptions, { startExpanded: false, nodeIds: nodeIds, isDimensioningEnabled: true, isPositioningEnabled: true })] })) }));
}
//# sourceMappingURL=SingleNodeProperties.js.map