var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { renameDrgElement } from "../mutations/renameNode";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "../dataTypes/useResolvedTypeRef";
import { useCallback } from "react";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function DecisionProperties(_a) {
    var _b, _c, _d, _e, _f;
    var decision = _a.decision, namespace = _a.namespace, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var isReadonly = !!namespace && namespace !== thisDmnsNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var resolvedTypeRef = useResolvedTypeRef((_b = decision.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"], namespace);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: decision["@_id"], name: decision["@_name"], isReadonly: isReadonly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) {
                        setState(function (state) {
                            renameDrgElement({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newName: newName,
                            });
                        });
                    }, allUniqueNames: useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []) }) })), _jsx(FormGroup, __assign({ label: "Data type" }, { children: _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, isDisabled: isReadonly, onChange: function (newTypeRef) {
                        setState(function (state) {
                            var _a;
                            var drgElement = state.dmn.model.definitions.drgElement[index];
                            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decision["@_name"] });
                            drgElement.variable["@_typeRef"] = newTypeRef;
                        });
                    } }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadonly, value: (_c = decision.description) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: decision["@_id"] })) })), _jsx(FormGroup, __assign({ label: "Question" }, { children: _jsx(TextArea, { "aria-label": "Question", type: "text", isDisabled: isReadonly, value: (_d = decision.question) === null || _d === void 0 ? void 0 : _d.__$$text, onChange: function (newQuestion) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].question = {
                                __$$text: newQuestion,
                            };
                        });
                    }, placeholder: "Enter a question...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "Allowed answers" }, { children: _jsx(TextArea, { "aria-label": "Allowed answers", type: "text", isDisabled: isReadonly, value: (_e = decision.allowedAnswers) === null || _e === void 0 ? void 0 : _e.__$$text, onChange: function (newAllowedAnswers) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].allowedAnswers = {
                                __$$text: newAllowedAnswers,
                            };
                        });
                    }, placeholder: "Enter allowed answers...", style: { resize: "vertical", minHeight: "40px" }, rows: 3 }) })), _jsx(DocumentationLinksFormGroup, { isReadonly: isReadonly, values: (_f = decision.extensionElements) === null || _f === void 0 ? void 0 : _f["kie:attachment"], onChange: function (newExtensionElements) {
                    setState(function (state) {
                        state.dmn.model.definitions.drgElement[index].extensionElements = {
                            "kie:attachment": newExtensionElements,
                        };
                    });
                } })] }));
}
//# sourceMappingURL=DecisionProperties.js.map