var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { DescriptionField, TextField, TextFieldType } from "./Fields";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditorStore } from "../../store/StoreContext";
export function DecisionTableRootCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Hit Policy", isReadonly: true, initialValue: (_b = cell["@_hitPolicy"]) !== null && _b !== void 0 ? _b : "" }), cell["@_hitPolicy"] === "COLLECT" && (_jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Aggregation", isReadonly: true, initialValue: (_c = cell["@_aggregation"]) !== null && _c !== void 0 ? _c : "<None>" })), _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Output Label", placeholder: "Enter a output label...", isReadonly: props.isReadonly, initialValue: (_d = cell["@_outputLabel"]) !== null && _d !== void 0 ? _d : "", onChange: function (newOutputLabel) {
                    return updater(function (dmnObject) {
                        dmnObject["@_outputLabel"] = newOutputLabel;
                    });
                }, expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [] }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_g = (_f = cell.description) === null || _f === void 0 ? void 0 : _f.__$$text) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: function (newDescription) {
                    return updater(function (dmnObject) {
                        var _a;
                        (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                        dmnObject.description.__$$text = newDescription;
                    });
                } })] }));
}
//# sourceMappingURL=DecisionTableRootCell.js.map