var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { DescriptionField, ExpressionLanguageField, TypeRefField } from "./Fields";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditor } from "../../DmnEditorContext";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function DecisionTableInputRule(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var headerType = useMemo(function () {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        var cellPath = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1];
        if (cellPath && cellPath.root) {
            var root = (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(cellPath.root);
            if (((_b = root === null || root === void 0 ? void 0 : root.expressionPath[root.expressionPath.length - 1]) === null || _b === void 0 ? void 0 : _b.type) === "decisionTable" &&
                cellPath.type === "decisionTable") {
                var _j = dmnEditorStoreApi
                    .getState()
                    .computed(dmnEditorStoreApi.getState())
                    .getDataTypes(externalModelsByNamespace), allDataTypesById = _j.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _j.allTopLevelItemDefinitionUniqueNames;
                var typeRef = (_g = allTopLevelItemDefinitionUniqueNames.get((_f = (_d = (_c = root === null || root === void 0 ? void 0 : root.cell) === null || _c === void 0 ? void 0 : _c.input) === null || _d === void 0 ? void 0 : _d[(_e = cellPath.column) !== null && _e !== void 0 ? _e : 0].inputExpression["@_typeRef"]) !== null && _f !== void 0 ? _f : "")) !== null && _g !== void 0 ? _g : DmnBuiltInDataType.Undefined;
                return { typeRef: typeRef, itemDefinition: (_h = allDataTypesById.get(typeRef)) === null || _h === void 0 ? void 0 : _h.itemDefinition };
            }
        }
    }, [dmnEditorStoreApi, externalModelsByNamespace, props.boxedExpressionIndex, selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), headerType && (_jsx(_Fragment, { children: _jsx(TypeRefField, { alternativeFieldName: "Input header type", isReadonly: true, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: (_c = (_b = headerType.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_name"]) !== null && _c !== void 0 ? _c : headerType.typeRef }) })), (headerType === null || headerType === void 0 ? void 0 : headerType.itemDefinition) && (_jsx(_Fragment, { children: _jsx(FormGroup, __assign({ label: "Constraint" }, { children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: true, itemDefinition: headerType.itemDefinition, editItemDefinition: function () { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) })) })), _jsx(ExpressionLanguageField, { isReadonly: props.isReadonly, initialValue: (_d = cell["@_expressionLanguage"]) !== null && _d !== void 0 ? _d : "", expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [], onChange: function (newExpressionLanguage) {
                    return updater(function (dmnObject) {
                        dmnObject["@_expressionLanguage"] = newExpressionLanguage;
                    });
                } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_g = (_f = cell.description) === null || _f === void 0 ? void 0 : _f.__$$text) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: function (newDescription) {
                    return updater(function (dmnObject) {
                        var _a;
                        (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                        dmnObject.description.__$$text = newDescription;
                    });
                } })] }));
}
//# sourceMappingURL=DecisionTableInputRuleCell.js.map