var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useMemo } from "react";
import { buildXmlHref } from "../xml/xmlHrefs";
import { SingleNodeProperties } from "./SingleNodeProperties";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export function BeePropertiesPanel() {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _a = useDmnEditorStore(function (s) { return s.boxedExpressionEditor; }), selectedObjectId = _a.selectedObjectId, activeDrgElementId = _a.activeDrgElementId;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var node = useDmnEditorStore(function (s) {
        return activeDrgElementId
            ? s
                .computed(s)
                .getDiagramData(externalModelsByNamespace)
                .nodesById.get(buildXmlHref({ id: activeDrgElementId }))
            : undefined;
    });
    var shouldDisplayDecisionOrBkmProps = useMemo(function () { return selectedObjectId === undefined || (selectedObjectId && selectedObjectId === activeDrgElementId); }, [activeDrgElementId, selectedObjectId]);
    return (_jsx(_Fragment, { children: node && (_jsx(DrawerPanelContent, __assign({ isResizable: true, minSize: "300px", defaultSize: "500px", onKeyDown: function (e) { return e.stopPropagation(); } }, { children: _jsxs(DrawerHead, { children: [shouldDisplayDecisionOrBkmProps && _jsx(SingleNodeProperties, { nodeId: node.id }), !shouldDisplayDecisionOrBkmProps && selectedObjectId === "" && _jsx("div", { children: "Nothing to show" }), !shouldDisplayDecisionOrBkmProps && selectedObjectId !== "" && _jsx("div", { children: selectedObjectId }), _jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClick: function () {
                                dmnEditorStoreApi.setState(function (state) {
                                    state.boxedExpressionEditor.propertiesPanel.isOpen = false;
                                });
                            } }) })] }) }))) }));
}
//# sourceMappingURL=BeePropertiesPanel.js.map