var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { renameDrgElement } from "./renameNode";
export function updateExpression(_a) {
    var _b, _c, _d;
    var definitions = _a.definitions, expression = _a.expression, drgElementIndex = _a.drgElementIndex;
    var drgElement = (_b = definitions.drgElement) === null || _b === void 0 ? void 0 : _b[drgElementIndex];
    if (!drgElement) {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that doesn't exist.");
    }
    renameDrgElement({
        definitions: definitions,
        newName: (_c = expression === null || expression === void 0 ? void 0 : expression["@_label"]) !== null && _c !== void 0 ? _c : drgElement["@_name"],
        index: drgElementIndex,
    });
    if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "decision") {
        drgElement.expression = expression;
        drgElement.variable["@_typeRef"] = expression ? expression["@_typeRef"] : drgElement.variable["@_typeRef"];
    }
    else if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "businessKnowledgeModel") {
        if (expression.__$$element !== "functionDefinition") {
            throw new Error("DMN MUTATION: Can't have an expression on a BKM that is not a Function.");
        }
        if (!(expression === null || expression === void 0 ? void 0 : expression.__$$element)) {
            throw new Error("DMN MUTATION: Can't determine expression type without its __$$element property.");
        }
        var __$$element = expression.__$$element, _updateExpression = __rest(expression, ["__$$element"]);
        drgElement.encapsulatedLogic = _updateExpression;
        drgElement.variable["@_typeRef"] = (_d = _updateExpression === null || _updateExpression === void 0 ? void 0 : _updateExpression["@_typeRef"]) !== null && _d !== void 0 ? _d : drgElement.variable["@_typeRef"];
    }
    else {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that is not a Decision or a BKM.");
    }
}
//# sourceMappingURL=updateExpression.js.map