import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
export var EdgeDeletionMode;
(function (EdgeDeletionMode) {
    EdgeDeletionMode[EdgeDeletionMode["FROM_DRG_AND_ALL_DRDS"] = 0] = "FROM_DRG_AND_ALL_DRDS";
    EdgeDeletionMode[EdgeDeletionMode["FROM_CURRENT_DRD_ONLY"] = 1] = "FROM_CURRENT_DRD_ONLY";
})(EdgeDeletionMode || (EdgeDeletionMode = {}));
export function deleteEdge(_a) {
    var _b, _c, _d, _e;
    var definitions = _a.definitions, drdIndex = _a.drdIndex, edge = _a.edge, mode = _a.mode;
    if (edge.dmnObject.namespace !== definitions["@_namespace"]) {
        console.debug("DMN MUTATION: Can't delete an edge that's from an external node.");
        return { dmnEdge: undefined };
    }
    var dmnObjects = (_b = switchExpression(edge === null || edge === void 0 ? void 0 : edge.dmnObject.type, {
        association: definitions.artifact,
        group: definitions.artifact,
        default: definitions.drgElement,
    })) !== null && _b !== void 0 ? _b : [];
    var dmnObjectIndex = dmnObjects.findIndex(function (d) { return d["@_id"] === edge.dmnObject.id; });
    if (dmnObjectIndex < 0) {
        throw new Error("DMN MUTATION: Can't find DMN element with ID ".concat(edge.dmnObject.id));
    }
    if (mode === EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
        var requirements = (_c = switchExpression(edge === null || edge === void 0 ? void 0 : edge.dmnObject.requirementType, {
            informationRequirement: dmnObjects[dmnObjectIndex].informationRequirement,
            knowledgeRequirement: dmnObjects[dmnObjectIndex].knowledgeRequirement,
            authorityRequirement: dmnObjects[dmnObjectIndex].authorityRequirement,
            association: dmnObjects,
        })) !== null && _c !== void 0 ? _c : [];
        var requirementIndex = (requirements !== null && requirements !== void 0 ? requirements : []).findIndex(function (d) { return d["@_id"] === edge.id; });
        if (requirementIndex >= 0) {
            requirements === null || requirements === void 0 ? void 0 : requirements.splice(requirementIndex, 1);
        }
    }
    var deletedDmnEdgeOnCurrentDrd;
    var drdCount = ((_e = (_d = definitions["dmndi:DMNDI"]) === null || _d === void 0 ? void 0 : _d["dmndi:DMNDiagram"]) !== null && _e !== void 0 ? _e : []).length;
    for (var i = 0; i < drdCount; i++) {
        var diagramElements = addOrGetDrd({ definitions: definitions, drdIndex: i }).diagramElements;
        if (mode === EdgeDeletionMode.FROM_CURRENT_DRD_ONLY && i !== drdIndex) {
            continue;
        }
        var dmnEdgeIndex = (diagramElements !== null && diagramElements !== void 0 ? diagramElements : []).findIndex(function (d) { return d["@_dmnElementRef"] === edge.id; });
        if (dmnEdgeIndex >= 0) {
            if (i === drdIndex) {
                deletedDmnEdgeOnCurrentDrd = diagramElements[dmnEdgeIndex];
            }
            diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.splice(dmnEdgeIndex, 1);
        }
    }
    repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions: definitions });
    return { deletedDmnEdgeOnCurrentDrd: deletedDmnEdgeOnCurrentDrd };
}
//# sourceMappingURL=deleteEdge.js.map