var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { getAutoLayoutedInfo } from "../autolayout/autoLayoutInfo";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
import { computeDiagramData } from "../store/computed/computeDiagramData";
import { computeExternalModelsByType } from "../store/computed/computeExternalModelsByType";
import { computeIndexedDrd } from "../store/computed/computeIndexes";
import { xmlHrefToQName } from "../xml/xmlHrefToQName";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
import { addOrGetDrd } from "./addOrGetDrd";
import { addShape } from "./addShape";
import { applyAutoLayoutToDrd } from "./applyAutoLayoutToDrd";
import { repositionNode } from "./repositionNode";
export var StrategyForAddingDecisionServiceToDrd;
(function (StrategyForAddingDecisionServiceToDrd) {
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["AUTO_GENERATE"] = 0] = "AUTO_GENERATE";
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["CONFLICT"] = 1] = "CONFLICT";
    StrategyForAddingDecisionServiceToDrd[StrategyForAddingDecisionServiceToDrd["COPY_FROM_ANOTHER_DRD"] = 2] = "COPY_FROM_ANOTHER_DRD";
})(StrategyForAddingDecisionServiceToDrd || (StrategyForAddingDecisionServiceToDrd = {}));
export function getStrategyToAddExistingDecisionServiceToDrd(_a) {
    var _b, _c, _d, _e;
    var __readonly_definitions = _a.__readonly_definitions, __readonly_decisionServiceNamespace = _a.__readonly_decisionServiceNamespace, __readonly_drgElement = _a.__readonly_drgElement, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex, __readonly_namespace = _a.__readonly_namespace, __readonly_indexedDrd = _a.__readonly_indexedDrd, __readonly_drdIndex = _a.__readonly_drdIndex;
    var decisionServiceDmnDefinitions = !__readonly_decisionServiceNamespace || __readonly_decisionServiceNamespace === __readonly_namespace
        ? __readonly_definitions
        : (_b = __readonly_externalDmnsIndex.get(__readonly_decisionServiceNamespace)) === null || _b === void 0 ? void 0 : _b.model.definitions;
    if (!decisionServiceDmnDefinitions) {
        throw new Error("DMN MUTATION: Can't find definitions for model with namespace ".concat(__readonly_decisionServiceNamespace));
    }
    var _f = getDecisionServicePropertiesRelativeToThisDmn({
        thisDmnsNamespace: __readonly_namespace,
        decisionServiceNamespace: __readonly_decisionServiceNamespace,
        decisionService: __readonly_drgElement,
    }), decisionServiceNamespaceForHref = _f.decisionServiceNamespaceForHref, containedDecisionHrefsRelativeToThisDmn = _f.containedDecisionHrefsRelativeToThisDmn;
    var decisionServiceHrefRelativeToThisDmn = buildXmlHref({
        namespace: decisionServiceNamespaceForHref,
        id: __readonly_drgElement["@_id"],
    });
    var containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = computeContainingDecisionServiceHrefsByDecisionHrefs({
        thisDmnsNamespace: __readonly_namespace,
        drgElementsNamespace: __readonly_decisionServiceNamespace,
        drgElements: decisionServiceDmnDefinitions.drgElement,
    });
    var doesThisDrdHaveConflictingDecisionService = containedDecisionHrefsRelativeToThisDmn.some(function (decisionHref) {
        var _a;
        return ((_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(decisionHref)) !== null && _a !== void 0 ? _a : []).some(function (d) {
            return __readonly_indexedDrd.dmnShapesByHref.has(d);
        });
    });
    if (doesThisDrdHaveConflictingDecisionService) {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.CONFLICT,
            decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
        };
    }
    var drds = (_d = (_c = decisionServiceDmnDefinitions["dmndi:DMNDI"]) === null || _c === void 0 ? void 0 : _c["dmndi:DMNDiagram"]) !== null && _d !== void 0 ? _d : [];
    var indexedDrd;
    var _loop_1 = function (i) {
        if (__readonly_namespace === __readonly_decisionServiceNamespace && i === __readonly_drdIndex) {
            return "continue";
        }
        var _indexedDrd = computeIndexedDrd(__readonly_namespace, decisionServiceDmnDefinitions, i);
        var dsShape = _indexedDrd.dmnShapesByHref.get(decisionServiceHrefRelativeToThisDmn);
        var hasCompleteExpandedDepictionOfDecisionService = dsShape &&
            !((_e = dsShape["@_isCollapsed"]) !== null && _e !== void 0 ? _e : false) &&
            containedDecisionHrefsRelativeToThisDmn.every(function (dHref) { return _indexedDrd.dmnShapesByHref.has(dHref); });
        if (hasCompleteExpandedDepictionOfDecisionService) {
            indexedDrd = _indexedDrd;
            return "break";
        }
    };
    for (var i = 0; i < drds.length; i++) {
        var state_1 = _loop_1(i);
        if (state_1 === "break")
            break;
    }
    if (indexedDrd === undefined) {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.AUTO_GENERATE,
            decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
        };
    }
    else {
        return {
            strategyForAddingDecisionServiceToDrd: StrategyForAddingDecisionServiceToDrd.COPY_FROM_ANOTHER_DRD,
            indexedDrdContainingDecisionServiceDepiction: indexedDrd,
            decisionServiceHrefRelativeToThisDmn: decisionServiceHrefRelativeToThisDmn,
            containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn,
        };
    }
}
export function addConflictingDecisionServiceToDrd(_a) {
    var definitions = _a.definitions, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_dropPoint = _a.__readonly_dropPoint, __readonly_decisionServiceHrefRelativeToThisDmn = _a.__readonly_decisionServiceHrefRelativeToThisDmn;
    addShape({
        definitions: definitions,
        drdIndex: __readonly_drdIndex,
        nodeType: NODE_TYPES.decisionService,
        shape: {
            "@_id": generateUuid(),
            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, definitions),
            "@_isCollapsed": true,
            "dc:Bounds": {
                "@_x": __readonly_dropPoint.x,
                "@_y": __readonly_dropPoint.y,
                "@_width": DECISION_SERVICE_COLLAPSED_DIMENSIONS.width,
                "@_height": DECISION_SERVICE_COLLAPSED_DIMENSIONS.height,
            },
        },
    });
}
export function addAutoGeneratedDecisionServiceToDrd(_a) {
    var _b, _c, _d, _e, _f, _g, _h;
    var _j;
    var state = _a.state, __readonly_decisionServiceNamespace = _a.__readonly_decisionServiceNamespace, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_snapGrid = _a.__readonly_snapGrid, __readonly_decisionServiceHrefRelativeToThisDmn = _a.__readonly_decisionServiceHrefRelativeToThisDmn, __readonly_containedDecisionHrefsRelativeToThisDmn = _a.__readonly_containedDecisionHrefsRelativeToThisDmn, __readonly_dropPoint = _a.__readonly_dropPoint, __readonly_isAlternativeInputDataShape = _a.__readonly_isAlternativeInputDataShape, __readonly_externalModelsByNamespace = _a.__readonly_externalModelsByNamespace;
    return __awaiter(this, void 0, void 0, function () {
        var drds, dummyDrdIndex, minNodeSize, __readonly_containedDecisionHrefsRelativeToThisDmn_1, __readonly_containedDecisionHrefsRelativeToThisDmn_1_1, decisionHref, decisionNs, decisionDmnDefinitions, minNodeSize_1, externalModelTypesByNamespace, dummyIndexedDrd, _k, nodes, nodesById, edges, edgesById, drgEdges, _l, __readonly_autoLayoutedInfo, __readonly_parentNodesById, _m, dsShapeX, dsShapeY, __readonly_containedDecisionHrefsRelativeToThisDmn_2, __readonly_containedDecisionHrefsRelativeToThisDmn_2_1, decisionHref, currentDecisionShape, x, y, _o, index, dmnElementRefQName, dsShape, __readonly_containedDecisionHrefsRelativeToThisDmn_3, __readonly_containedDecisionHrefsRelativeToThisDmn_3_1, decisionHref, _p, index_1, dmnElementRefQName_1, decisionShape;
        var e_1, _q, e_2, _r, e_3, _s;
        return __generator(this, function (_t) {
            switch (_t.label) {
                case 0:
                    drds = (_b = state.dmn.model.definitions["dmndi:DMNDI"]) === null || _b === void 0 ? void 0 : _b["dmndi:DMNDiagram"];
                    dummyDrdIndex = (drds === null || drds === void 0 ? void 0 : drds.length) === undefined ? 0 : drds.length;
                    addOrGetDrd({
                        definitions: state.dmn.model.definitions,
                        drdIndex: dummyDrdIndex,
                    });
                    minNodeSize = MIN_NODE_SIZES[NODE_TYPES.decisionService]({
                        snapGrid: __readonly_snapGrid,
                    });
                    addShape({
                        definitions: state.dmn.model.definitions,
                        drdIndex: dummyDrdIndex,
                        nodeType: NODE_TYPES.decisionService,
                        shape: {
                            "@_id": generateUuid(),
                            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, state.dmn.model.definitions),
                            "dc:Bounds": __assign({ "@_x": 0, "@_y": 0 }, minNodeSize),
                        },
                    });
                    try {
                        for (__readonly_containedDecisionHrefsRelativeToThisDmn_1 = __values(__readonly_containedDecisionHrefsRelativeToThisDmn), __readonly_containedDecisionHrefsRelativeToThisDmn_1_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_1.next(); !__readonly_containedDecisionHrefsRelativeToThisDmn_1_1.done; __readonly_containedDecisionHrefsRelativeToThisDmn_1_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_1.next()) {
                            decisionHref = __readonly_containedDecisionHrefsRelativeToThisDmn_1_1.value;
                            decisionNs = parseXmlHref(decisionHref).namespace;
                            decisionDmnDefinitions = !decisionNs || decisionNs === state.dmn.model.definitions["@_namespace"]
                                ? state.dmn.model.definitions
                                : (_c = __readonly_externalDmnsIndex.get(decisionNs)) === null || _c === void 0 ? void 0 : _c.model.definitions;
                            if (!decisionDmnDefinitions) {
                                throw new Error("DMN MUTATION: Can't find definitions for model with namespace ".concat(__readonly_decisionServiceNamespace));
                            }
                            minNodeSize_1 = MIN_NODE_SIZES[NODE_TYPES.decision]({
                                snapGrid: __readonly_snapGrid,
                            });
                            addShape({
                                definitions: state.dmn.model.definitions,
                                drdIndex: dummyDrdIndex,
                                nodeType: NODE_TYPES.decision,
                                shape: {
                                    "@_id": generateUuid(),
                                    "@_dmnElementRef": xmlHrefToQName(decisionHref, state.dmn.model.definitions),
                                    "dc:Bounds": __assign({ "@_x": 0, "@_y": 0 }, minNodeSize_1),
                                },
                            });
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (__readonly_containedDecisionHrefsRelativeToThisDmn_1_1 && !__readonly_containedDecisionHrefsRelativeToThisDmn_1_1.done && (_q = __readonly_containedDecisionHrefsRelativeToThisDmn_1.return)) _q.call(__readonly_containedDecisionHrefsRelativeToThisDmn_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    externalModelTypesByNamespace = computeExternalModelsByType(state.dmn.model.definitions.import, __readonly_externalModelsByNamespace);
                    dummyIndexedDrd = computeIndexedDrd(state.dmn.model.definitions["@_namespace"], state.dmn.model.definitions, dummyDrdIndex);
                    _k = computeDiagramData(state.diagram, state.dmn.model.definitions, externalModelTypesByNamespace, dummyIndexedDrd, __readonly_isAlternativeInputDataShape), nodes = _k.nodes, nodesById = _k.nodesById, edges = _k.edges, edgesById = _k.edgesById, drgEdges = _k.drgEdges;
                    return [4, getAutoLayoutedInfo({
                            __readonly_snapGrid: __readonly_snapGrid,
                            __readonly_nodesById: nodesById,
                            __readonly_edgesById: edgesById,
                            __readonly_nodes: nodes,
                            __readonly_drgEdges: drgEdges,
                            __readonly_isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
                        })];
                case 1:
                    _l = _t.sent(), __readonly_autoLayoutedInfo = _l.__readonly_autoLayoutedInfo, __readonly_parentNodesById = _l.__readonly_parentNodesById;
                    applyAutoLayoutToDrd({
                        state: state,
                        __readonly_dmnShapesByHref: dummyIndexedDrd.dmnShapesByHref,
                        __readonly_edges: edges,
                        __readonly_edgesById: edgesById,
                        __readonly_nodesById: nodesById,
                        __readonly_autoLayoutedInfo: __readonly_autoLayoutedInfo,
                        __readonly_parentNodesById: __readonly_parentNodesById,
                        __readonly_drdIndex: dummyDrdIndex,
                        __readonly_dmnObjectNamespace: __readonly_decisionServiceNamespace,
                        __readonly_externalDmnsIndex: externalModelTypesByNamespace.dmns,
                    });
                    _m = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn)["dc:Bounds"], dsShapeX = _m["@_x"], dsShapeY = _m["@_y"];
                    repositionNode({
                        definitions: state.dmn.model.definitions,
                        drdIndex: dummyDrdIndex,
                        controlWaypointsByEdge: new Map(),
                        change: {
                            nodeType: NODE_TYPES.decisionService,
                            type: "absolute",
                            position: { x: __readonly_dropPoint.x, y: __readonly_dropPoint.y },
                            shapeIndex: (_e = (_d = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn)) === null || _d === void 0 ? void 0 : _d.index) !== null && _e !== void 0 ? _e : 0,
                            selectedEdges: [],
                            sourceEdgeIndexes: [],
                            targetEdgeIndexes: [],
                        },
                    });
                    try {
                        for (__readonly_containedDecisionHrefsRelativeToThisDmn_2 = __values(__readonly_containedDecisionHrefsRelativeToThisDmn), __readonly_containedDecisionHrefsRelativeToThisDmn_2_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_2.next(); !__readonly_containedDecisionHrefsRelativeToThisDmn_2_1.done; __readonly_containedDecisionHrefsRelativeToThisDmn_2_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_2.next()) {
                            decisionHref = __readonly_containedDecisionHrefsRelativeToThisDmn_2_1.value;
                            currentDecisionShape = dummyIndexedDrd.dmnShapesByHref.get(decisionHref);
                            x = __readonly_dropPoint.x + currentDecisionShape["dc:Bounds"]["@_x"] - dsShapeX;
                            y = __readonly_dropPoint.y + currentDecisionShape["dc:Bounds"]["@_y"] - dsShapeY;
                            if (currentDecisionShape) {
                                repositionNode({
                                    definitions: state.dmn.model.definitions,
                                    drdIndex: dummyDrdIndex,
                                    controlWaypointsByEdge: new Map(),
                                    change: {
                                        nodeType: NODE_TYPES.decision,
                                        type: "absolute",
                                        position: { x: x, y: y },
                                        shapeIndex: currentDecisionShape.index,
                                        selectedEdges: [],
                                        sourceEdgeIndexes: [],
                                        targetEdgeIndexes: [],
                                    },
                                });
                            }
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (__readonly_containedDecisionHrefsRelativeToThisDmn_2_1 && !__readonly_containedDecisionHrefsRelativeToThisDmn_2_1.done && (_r = __readonly_containedDecisionHrefsRelativeToThisDmn_2.return)) _r.call(__readonly_containedDecisionHrefsRelativeToThisDmn_2);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    if (dummyDrdIndex !== __readonly_drdIndex) {
                        _o = dummyIndexedDrd.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn), index = _o.index, dmnElementRefQName = _o.dmnElementRefQName, dsShape = __rest(_o, ["index", "dmnElementRefQName"]);
                        (_f = (_j = drds[__readonly_drdIndex])["dmndi:DMNDiagramElement"]) !== null && _f !== void 0 ? _f : (_j["dmndi:DMNDiagramElement"] = []);
                        (_g = drds === null || drds === void 0 ? void 0 : drds[__readonly_drdIndex]["dmndi:DMNDiagramElement"]) === null || _g === void 0 ? void 0 : _g.push(__assign(__assign({}, dsShape), { __$$element: "dmndi:DMNShape" }));
                        try {
                            for (__readonly_containedDecisionHrefsRelativeToThisDmn_3 = __values(__readonly_containedDecisionHrefsRelativeToThisDmn), __readonly_containedDecisionHrefsRelativeToThisDmn_3_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_3.next(); !__readonly_containedDecisionHrefsRelativeToThisDmn_3_1.done; __readonly_containedDecisionHrefsRelativeToThisDmn_3_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_3.next()) {
                                decisionHref = __readonly_containedDecisionHrefsRelativeToThisDmn_3_1.value;
                                _p = dummyIndexedDrd.dmnShapesByHref.get(decisionHref), index_1 = _p.index, dmnElementRefQName_1 = _p.dmnElementRefQName, decisionShape = __rest(_p, ["index", "dmnElementRefQName"]);
                                (_h = drds === null || drds === void 0 ? void 0 : drds[__readonly_drdIndex]["dmndi:DMNDiagramElement"]) === null || _h === void 0 ? void 0 : _h.push(__assign(__assign({}, decisionShape), { __$$element: "dmndi:DMNShape" }));
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (__readonly_containedDecisionHrefsRelativeToThisDmn_3_1 && !__readonly_containedDecisionHrefsRelativeToThisDmn_3_1.done && (_s = __readonly_containedDecisionHrefsRelativeToThisDmn_3.return)) _s.call(__readonly_containedDecisionHrefsRelativeToThisDmn_3);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        drds === null || drds === void 0 ? void 0 : drds.pop();
                    }
                    else {
                    }
                    return [2];
            }
        });
    });
}
export function addExistingDecisionServiceToDrd(_a) {
    var e_4, _b;
    var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
    var definitions = _a.definitions, __readonly_decisionServiceNamespace = _a.__readonly_decisionServiceNamespace, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex, __readonly_namespace = _a.__readonly_namespace, __readonly_indexedDrd = _a.__readonly_indexedDrd, __readonly_indexedDrdContainingDecisionServiceDepiction = _a.__readonly_indexedDrdContainingDecisionServiceDepiction, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_dropPoint = _a.__readonly_dropPoint, __readonly_decisionServiceHrefRelativeToThisDmn = _a.__readonly_decisionServiceHrefRelativeToThisDmn, __readonly_containedDecisionHrefsRelativeToThisDmn = _a.__readonly_containedDecisionHrefsRelativeToThisDmn;
    var dsShapeOnOtherDrd = __readonly_indexedDrdContainingDecisionServiceDepiction.dmnShapesByHref.get(__readonly_decisionServiceHrefRelativeToThisDmn);
    if (((_c = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _c === void 0 ? void 0 : _c["@_x"]) === undefined ||
        ((_d = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _d === void 0 ? void 0 : _d["@_y"]) === undefined) {
        throw new Error("DMN MUTATION: Complete DMNShape for Decision Service with href ".concat(__readonly_decisionServiceHrefRelativeToThisDmn, " should've existed on the indexed DRD."));
    }
    var dsDividirLineOnOtherDrd = dsShapeOnOtherDrd["dmndi:DMNDecisionServiceDividerLine"];
    var decisionServiceDividerLineWaypoint = [
        {
            "@_x": __readonly_dropPoint.x,
            "@_y": ((_f = (_e = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _e === void 0 ? void 0 : _e[0]["@_y"]) !== null && _f !== void 0 ? _f : 0) -
                ((_h = (_g = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _g === void 0 ? void 0 : _g["@_y"]) !== null && _h !== void 0 ? _h : 0) +
                __readonly_dropPoint.y,
        },
        {
            "@_x": ((_k = (_j = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _j === void 0 ? void 0 : _j[1]["@_x"]) !== null && _k !== void 0 ? _k : 0) -
                ((_m = (_l = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _l === void 0 ? void 0 : _l[0]["@_x"]) !== null && _m !== void 0 ? _m : 0) +
                __readonly_dropPoint.x,
            "@_y": ((_p = (_o = dsDividirLineOnOtherDrd === null || dsDividirLineOnOtherDrd === void 0 ? void 0 : dsDividirLineOnOtherDrd["di:waypoint"]) === null || _o === void 0 ? void 0 : _o[0]["@_y"]) !== null && _p !== void 0 ? _p : 0) -
                ((_r = (_q = dsShapeOnOtherDrd === null || dsShapeOnOtherDrd === void 0 ? void 0 : dsShapeOnOtherDrd["dc:Bounds"]) === null || _q === void 0 ? void 0 : _q["@_y"]) !== null && _r !== void 0 ? _r : 0) +
                __readonly_dropPoint.y,
        },
    ];
    addShape({
        definitions: definitions,
        drdIndex: __readonly_drdIndex,
        nodeType: NODE_TYPES.decisionService,
        shape: {
            "@_id": generateUuid(),
            "@_dmnElementRef": xmlHrefToQName(__readonly_decisionServiceHrefRelativeToThisDmn, definitions),
            "dc:Bounds": {
                "@_x": __readonly_dropPoint.x,
                "@_y": __readonly_dropPoint.y,
                "@_width": dsShapeOnOtherDrd["dc:Bounds"]["@_width"],
                "@_height": dsShapeOnOtherDrd["dc:Bounds"]["@_height"],
            },
        },
        decisionServiceDividerLineWaypoint: decisionServiceDividerLineWaypoint,
    });
    try {
        for (var __readonly_containedDecisionHrefsRelativeToThisDmn_4 = __values(__readonly_containedDecisionHrefsRelativeToThisDmn), __readonly_containedDecisionHrefsRelativeToThisDmn_4_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_4.next(); !__readonly_containedDecisionHrefsRelativeToThisDmn_4_1.done; __readonly_containedDecisionHrefsRelativeToThisDmn_4_1 = __readonly_containedDecisionHrefsRelativeToThisDmn_4.next()) {
            var decisionHref = __readonly_containedDecisionHrefsRelativeToThisDmn_4_1.value;
            var decisionShapeOnOtherDrd = __readonly_indexedDrdContainingDecisionServiceDepiction.dmnShapesByHref.get(decisionHref);
            if (((_s = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _s === void 0 ? void 0 : _s["@_x"]) === undefined ||
                ((_t = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _t === void 0 ? void 0 : _t["@_y"]) === undefined ||
                ((_u = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _u === void 0 ? void 0 : _u["@_width"]) === undefined ||
                ((_v = decisionShapeOnOtherDrd === null || decisionShapeOnOtherDrd === void 0 ? void 0 : decisionShapeOnOtherDrd["dc:Bounds"]) === null || _v === void 0 ? void 0 : _v["@_height"]) === undefined) {
                throw new Error("DMN MUTATION: Complete DMNShape for Decision with href ".concat(decisionHref, " should've existed on the indexed DRD."));
            }
            var x = __readonly_dropPoint.x + (decisionShapeOnOtherDrd["dc:Bounds"]["@_x"] - dsShapeOnOtherDrd["dc:Bounds"]["@_x"]);
            var y = __readonly_dropPoint.y + (decisionShapeOnOtherDrd["dc:Bounds"]["@_y"] - dsShapeOnOtherDrd["dc:Bounds"]["@_y"]);
            var existingDecisionShape = __readonly_indexedDrd.dmnShapesByHref.get(decisionHref);
            if (existingDecisionShape) {
                repositionNode({
                    definitions: definitions,
                    drdIndex: __readonly_drdIndex,
                    controlWaypointsByEdge: new Map(),
                    change: {
                        nodeType: NODE_TYPES.decision,
                        type: "absolute",
                        position: { x: x, y: y },
                        shapeIndex: existingDecisionShape.index,
                        selectedEdges: [],
                        sourceEdgeIndexes: [],
                        targetEdgeIndexes: [],
                    },
                });
            }
            else {
                var decisionNs = parseXmlHref(decisionHref).namespace;
                var decisionDmnDefinitions = !decisionNs || decisionNs === __readonly_namespace
                    ? definitions
                    : (_w = __readonly_externalDmnsIndex.get(decisionNs)) === null || _w === void 0 ? void 0 : _w.model.definitions;
                if (!decisionDmnDefinitions) {
                    throw new Error("DMN MUTATION: Can't find definitions for model with namespace ".concat(__readonly_decisionServiceNamespace));
                }
                addShape({
                    definitions: definitions,
                    drdIndex: __readonly_drdIndex,
                    nodeType: NODE_TYPES.decision,
                    shape: {
                        "@_id": generateUuid(),
                        "@_dmnElementRef": xmlHrefToQName(decisionHref, definitions),
                        "dc:Bounds": {
                            "@_x": x,
                            "@_y": y,
                            "@_width": decisionShapeOnOtherDrd["dc:Bounds"]["@_width"],
                            "@_height": decisionShapeOnOtherDrd["dc:Bounds"]["@_height"],
                        },
                    },
                });
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (__readonly_containedDecisionHrefsRelativeToThisDmn_4_1 && !__readonly_containedDecisionHrefsRelativeToThisDmn_4_1.done && (_b = __readonly_containedDecisionHrefsRelativeToThisDmn_4.return)) _b.call(__readonly_containedDecisionHrefsRelativeToThisDmn_4);
        }
        finally { if (e_4) throw e_4.error; }
    }
}
export function getDecisionServicePropertiesRelativeToThisDmn(_a) {
    var _b, _c;
    var thisDmnsNamespace = _a.thisDmnsNamespace, decisionServiceNamespace = _a.decisionServiceNamespace, decisionService = _a.decisionService;
    var decisionServiceNamespaceForHref = decisionServiceNamespace === thisDmnsNamespace ? "" : decisionServiceNamespace;
    var containedDecisionHrefsRelativeToThisDmn = __spreadArray(__spreadArray([], __read(((_b = decisionService.outputDecision) !== null && _b !== void 0 ? _b : [])), false), __read(((_c = decisionService.encapsulatedDecision) !== null && _c !== void 0 ? _c : [])), false).map(function (d) {
        var parsedHref = parseXmlHref(d["@_href"]);
        return buildXmlHref({
            namespace: !parsedHref.namespace ? decisionServiceNamespaceForHref : parsedHref.namespace,
            id: parsedHref.id,
        });
    });
    return { decisionServiceNamespaceForHref: decisionServiceNamespaceForHref, containedDecisionHrefsRelativeToThisDmn: containedDecisionHrefsRelativeToThisDmn };
}
//# sourceMappingURL=addExistingDecisionServiceToDrd.js.map