var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { DEFAULT_INTRACTION_WIDTH } from "../maths/DmnMaths";
import { DEFAULT_NODE_FILL, DEFAULT_NODE_STROKE_COLOR, DEFAULT_NODE_STROKE_WIDTH } from "./NodeStyle";
export var ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches = { flag: false };
export function normalize(_props) {
    var _strokeWidth = _props.strokeWidth, _x = _props.x, _y = _props.y, _width = _props.width, _height = _props.height, _fillColor = _props.fillColor, _strokeColor = _props.strokeColor, props = __rest(_props, ["strokeWidth", "x", "y", "width", "height", "fillColor", "strokeColor"]);
    var strokeWidth = _strokeWidth !== null && _strokeWidth !== void 0 ? _strokeWidth : DEFAULT_NODE_STROKE_WIDTH;
    var halfStrokeWidth = strokeWidth / 2;
    var x = _x + halfStrokeWidth;
    var y = _y + halfStrokeWidth;
    var width = _width - strokeWidth;
    var height = _height - strokeWidth;
    return {
        strokeWidth: strokeWidth,
        x: x,
        y: y,
        width: width + (___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag ? 0.1 : 0),
        height: height + (___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag ? 0 : 0.1),
        fillColor: _fillColor,
        strokeColor: _strokeColor,
        props: props,
    };
}
export function InputDataNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _b = _a.props, isCollection = _b.isCollection, props = __rest(_b, ["isCollection"]);
    var rx = typeof height === "number"
        ? height / 2
        : (function () {
            throw new Error("Can't calculate rx based on a string height.");
        })();
    var ry = typeof width === "number"
        ? width / 2
        : (function () {
            throw new Error("Can't calculate ry based on a string width.");
        })();
    return (_jsxs(_Fragment, { children: [_jsx("rect", __assign({}, props, { x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, rx: rx, ry: ry })), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "bottom" }))] }));
}
export function AlternativeInputDataNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _b = _a.props, isCollection = _b.isCollection, isIcon = _b.isIcon, props = __rest(_b, ["isCollection", "isIcon"]);
    var bevel = 25;
    var arrowStartingX = 6;
    var arrowStartingY = 10;
    return (_jsxs(_Fragment, { children: [_jsx("polygon", __assign({}, props, { points: "0,0 0,".concat(height, " ").concat(width, ",").concat(height, " ").concat(width, ",").concat(bevel, " ").concat(width - bevel, ",0 ").concat(width - bevel, ",0"), fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: isIcon ? __props.transform : "translate(".concat(x, ",").concat(y, ")") })), isIcon === false && (_jsxs(_Fragment, { children: [_jsx("polygon", __assign({}, props, { points: "".concat(width - bevel, ",0 ").concat(width - bevel, ",").concat(bevel, " ").concat(width, ",").concat(bevel), fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: "translate(".concat(x, ",").concat(y, ")") })), _jsx("polygon", __assign({}, props, { points: "".concat(arrowStartingX, ",").concat(arrowStartingY, " ").concat(arrowStartingX, ",20 20,20 20,26 30,15 20,4 20,").concat(arrowStartingY, " "), fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: "translate(".concat(x, ",").concat(y, ")") }))] })), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "bottom" }))] }));
}
export function DecisionNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _b = _a.props, isCollection = _b.isCollection, hasHiddenRequirements = _b.hasHiddenRequirements, props = __rest(_b, ["isCollection", "hasHiddenRequirements"]);
    return (_jsxs(_Fragment, { children: [_jsx("rect", __assign({ x: x, y: y, strokeWidth: strokeWidth, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round" }, props)), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "top" })), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: height, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "middle" }))] }));
}
export function BkmNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _b = _a.props, hasHiddenRequirements = _b.hasHiddenRequirements, props = __rest(_b, ["hasHiddenRequirements"]);
    var bevel = 25;
    return (_jsxs(_Fragment, { children: [_jsx("polygon", __assign({}, props, { points: "".concat(bevel, ",0 0,").concat(bevel, " 0,").concat(height, " ").concat(width - bevel, ",").concat(height, " ").concat(width, ",").concat(height - bevel, ", ").concat(width, ",0"), fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: "translate(".concat(x, ",").concat(y, ")") })), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: height, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "middle" }))] }));
}
export function KnowledgeSourceNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, totalHeight = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _b = _a.props, hasHiddenRequirements = _b.hasHiddenRequirements, props = __rest(_b, ["hasHiddenRequirements"]);
    var amplitude = 20;
    var height = totalHeight - amplitude / 2;
    var straightLines = "M".concat(width, ",").concat(height, " L").concat(width, ",0 L0,0 L0,").concat(height);
    var bottomWave = "Q".concat(width / 4, ",").concat(height + amplitude, " ").concat(width / 2, ",").concat(height, " T").concat(width, ",").concat(height);
    return (_jsxs(_Fragment, { children: [_jsx("path", __assign({}, props, { d: "".concat(straightLines, " ").concat(bottomWave, " Z"), fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: "translate(".concat(x, ",").concat(y, ")") })), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: totalHeight, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "left" }))] }));
}
export var containerNodeInteractionRectCssClassName = "kie-dmn-editor--node-containerNodeInteractionRect";
export var DecisionServiceNodeSvg = React.forwardRef(function (__props, ref) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _props = _a.props;
    var _b = normalize(__assign(__assign({}, __props), { strokeWidth: DEFAULT_INTRACTION_WIDTH / 2 })), interactionRectStrokeWidth = _b.strokeWidth, interactionRectX = _b.x, interactionRectY = _b.y, interactionRectWidth = _b.width, interactionRectHeight = _b.height, _interactionRectProps = _b.props;
    var dividerLineLocalY = _props.dividerLineLocalY, showSectionLabels = _props.showSectionLabels, dividerLineRef = _props.dividerLineRef, isCollapsed = _props.isCollapsed, isReadonly = _props.isReadonly, props = __rest(_props, ["dividerLineLocalY", "showSectionLabels", "dividerLineRef", "isCollapsed", "isReadonly"]);
    var dividerLineCoords = {
        x: x + strokeWidth / 2,
        y: y + (dividerLineLocalY ? dividerLineLocalY : height / 2),
    };
    var interactionRectDividerLineLocalY = _interactionRectProps.dividerLineLocalY, interactionRectShowSectionLabels = _interactionRectProps.showSectionLabels, interactionRectDividerLineRef = _interactionRectProps.dividerLineRef, interactionRectIsCollapsed = _interactionRectProps.isCollapsed, interactionRectIsReadonly = _interactionRectProps.isReadonly, interactionRectProps = __rest(_interactionRectProps, ["dividerLineLocalY", "showSectionLabels", "dividerLineRef", "isCollapsed", "isReadonly"]);
    return (_jsxs(_Fragment, { children: [!isCollapsed && (_jsxs(_Fragment, { children: [_jsx("path", { ref: dividerLineRef, className: "kie-dmn-editor--node-decisionService-interactionDividerLine ".concat(isReadonly ? "readonly" : ""), d: "M0,0 L".concat(width, ",0"), strokeWidth: DEFAULT_INTRACTION_WIDTH / 2, style: { stroke: "transparent !important" }, transform: "translate(".concat(dividerLineCoords.x, ",").concat(dividerLineCoords.y, ")") }), _jsx("path", { d: "M0,0 L".concat(width, ",0"), strokeLinejoin: "round", strokeWidth: strokeWidth, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, transform: "translate(".concat(dividerLineCoords.x, ",").concat(dividerLineCoords.y, ")") })] })), _jsx("rect", __assign({}, props, { x: x, y: y, width: width, height: height, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", rx: "40", ry: "40", className: "kie-dmn-editor--node-decisionService-visibleRect" })), _jsx("rect", __assign({}, interactionRectProps, { ref: ref, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, strokeWidth: interactionRectStrokeWidth, fill: "transparent", stroke: "transparent", strokeLinejoin: "round", rx: "30", ry: "30", className: containerNodeInteractionRectCssClassName })), showSectionLabels && !isCollapsed && (_jsxs(_Fragment, { children: [_jsx("text", __assign({ className: "kie-dmn-editor--decision-service-label", textAnchor: "middle", dominantBaseline: "auto", transform: "translate(".concat(dividerLineCoords.x + width / 2, ",").concat(dividerLineCoords.y - 6, ")") }, { children: "OUTPUT" })), _jsx("text", __assign({ className: "kie-dmn-editor--decision-service-label", textAnchor: "middle", dominantBaseline: "hanging", transform: "translate(".concat(dividerLineCoords.x + width / 2, ",").concat(dividerLineCoords.y + 6, ")") }, { children: "ENCAPSULATED" }))] }))] }));
});
export function TextAnnotationNodeSvg(__props) {
    var _a = normalize(__props), strokeWidth = _a.strokeWidth, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fillColor = _a.fillColor, strokeColor = _a.strokeColor, _props = _a.props;
    var showPlaceholder = _props.showPlaceholder, props = __rest(_props, ["showPlaceholder"]);
    return (_jsxs(_Fragment, { children: [_jsx("rect", { x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: "transparent", strokeLinejoin: "round", transform: "translate(".concat(x, ",").concat(y, ")") }), _jsx("path", __assign({}, props, { x: x, y: y, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", d: "M20,0 L0,0 M0,0 L0,".concat(height, " M0,").concat(height, " L20,").concat(height), stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: "translate(".concat(x, ",").concat(y, ")") })), showPlaceholder && (_jsx("text", __assign({ x: "20%", y: "62.5%", style: { fontSize: "5em", fontWeight: "bold" } }, { children: "Text" })))] }));
}
export var GroupNodeSvg = React.forwardRef(function (__props, ref) {
    var _a;
    var _b = normalize(__props), strokeWidth = _b.strokeWidth, x = _b.x, y = _b.y, width = _b.width, height = _b.height, fillColor = _b.fillColor, strokeColor = _b.strokeColor, props = _b.props;
    var _c = normalize(__assign(__assign({}, __props), { strokeWidth: DEFAULT_INTRACTION_WIDTH / 2 })), interactionRectStrokeWidth = _c.strokeWidth, interactionRectX = _c.x, interactionRectY = _c.y, interactionRectWidth = _c.width, interactionRectHeight = _c.height, _interactionRectProps = _c.props;
    var interactionRectStrokeDasharray = _interactionRectProps.strokeDasharray, interactionRectProps = __rest(_interactionRectProps, ["strokeDasharray"]);
    var strokeDasharray = (_a = props.strokeDasharray) !== null && _a !== void 0 ? _a : "14,10,3,10";
    return (_jsxs(_Fragment, { children: [_jsx("rect", __assign({}, props, { x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, strokeDasharray: strokeDasharray, rx: 40, ry: 40 })), _jsx("rect", __assign({}, interactionRectProps, { ref: ref, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, strokeWidth: interactionRectStrokeWidth, fill: "transparent", stroke: "transparent", rx: "30", ry: "30", className: containerNodeInteractionRectCssClassName }))] }));
});
export function UnknownNodeSvg(_props) {
    var _a;
    var _b = normalize(_props), strokeWidth = _b.strokeWidth, x = _b.x, y = _b.y, width = _b.width, height = _b.height, props = _b.props;
    var strokeDasharray = (_a = props.strokeDasharray) !== null && _a !== void 0 ? _a : "2,4";
    return (_jsx(_Fragment, { children: _jsx("rect", __assign({}, props, { x: x, y: y, width: width, height: height, fill: "transparent", stroke: "red", strokeLinejoin: "round", strokeWidth: strokeWidth, strokeDasharray: strokeDasharray })) }));
}
function NodeCollectionMarker(_a) {
    var strokeWidth = _a.strokeWidth, strokeColor = _a.strokeColor, fillColor = _a.fillColor, x = _a.x, y = _a.y, width = _a.width, height = _a.height, anchor = _a.anchor;
    var xPosition = x + width / 2;
    var xSpacing = 7;
    var y1Position = anchor === "bottom" ? y + height - 4 : y + 4;
    var y2Position = anchor === "bottom" ? y + height - 18 : y + 18;
    return (_jsxs(_Fragment, { children: [_jsx("line", { x1: xPosition - xSpacing, x2: xPosition - xSpacing, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("line", { x1: xPosition, x2: xPosition, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("line", { x1: xPosition + xSpacing, x2: xPosition + xSpacing, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR })] }));
}
function NodeHiddenRequirementMarker(_a) {
    var strokeWidth = _a.strokeWidth, strokeColor = _a.strokeColor, x = _a.x, y = _a.y, width = _a.width, height = _a.height, anchor = _a.anchor;
    var dotRadius = 1;
    var xPosition = anchor === "middle" ? x + width / 2 : x + width / 4;
    var xSpacing = 7;
    var yPosition = anchor === "middle" ? y + height - 18 : y + height - 11;
    return (_jsxs(_Fragment, { children: [_jsx("circle", { r: dotRadius, cx: xPosition - xSpacing, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("circle", { r: dotRadius, cx: xPosition, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("circle", { r: dotRadius, cx: xPosition + xSpacing, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR })] }));
}
//# sourceMappingURL=NodeSvgs.js.map