import { useMemo } from "react";
import { NODE_TYPES } from "./NodeTypes";
export var DEFAULT_NODE_RED_FILL = 255;
export var DEFAULT_NODE_GREEN_FILL = 255;
export var DEFAULT_NODE_BLUE_FILL = 255;
export var DEFAULT_NODE_OPACITY = 0.9;
export var DEFAULT_NODE_FILL = "rgba(".concat(DEFAULT_NODE_RED_FILL, ", ").concat(DEFAULT_NODE_GREEN_FILL, ", ").concat(DEFAULT_NODE_BLUE_FILL, ", ").concat(DEFAULT_NODE_OPACITY, ")");
export var DEFAULT_NODE_STROKE_WIDTH = 1.5;
export var DEFAULT_NODE_STROKE_COLOR = "rgba(0, 0, 0, 1)";
export var DEFAULT_FONT_COLOR = "rgba(0, 0, 0, 1)";
export function useNodeStyle(args) {
    var fillColor = useMemo(function () { return getNodeShapeFillColor({ dmnStyle: args.dmnStyle, nodeType: args.nodeType, isEnabled: args.isEnabled }); }, [args.dmnStyle, args.isEnabled, args.nodeType]);
    var strokeColor = useMemo(function () { return getNodeShapeStrokeColor({ dmnStyle: args.dmnStyle, isEnabled: args.isEnabled }); }, [args.dmnStyle, args.isEnabled]);
    var dmnFontStyle = useMemo(function () { return getDmnFontStyle({ dmnStyle: args.dmnStyle, isEnabled: args.isEnabled }); }, [args.dmnStyle, args.isEnabled]);
    return useMemo(function () {
        return getNodeStyle({
            fillColor: fillColor,
            strokeColor: strokeColor,
            dmnFontStyle: dmnFontStyle,
        });
    }, [fillColor, dmnFontStyle, strokeColor]);
}
export function getNodeStyle(_a) {
    var fillColor = _a.fillColor, strokeColor = _a.strokeColor, dmnFontStyle = _a.dmnFontStyle;
    return {
        fontCssProperties: getFontCssProperties(dmnFontStyle),
        shapeStyle: {
            fillColor: fillColor,
            strokeColor: strokeColor,
            strokeWidth: DEFAULT_NODE_STROKE_WIDTH,
        },
    };
}
export function getNodeShapeFillColor(args) {
    var _a, _b, _c, _d, _e, _f;
    var blue = (_b = (_a = args.dmnStyle) === null || _a === void 0 ? void 0 : _a["dmndi:FillColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"];
    var green = (_d = (_c = args.dmnStyle) === null || _c === void 0 ? void 0 : _c["dmndi:FillColor"]) === null || _d === void 0 ? void 0 : _d["@_green"];
    var red = (_f = (_e = args.dmnStyle) === null || _e === void 0 ? void 0 : _e["dmndi:FillColor"]) === null || _f === void 0 ? void 0 : _f["@_red"];
    var opacity = args.nodeType === NODE_TYPES.decisionService ||
        args.nodeType === NODE_TYPES.group ||
        args.nodeType === NODE_TYPES.textAnnotation
        ? 0.1
        : DEFAULT_NODE_OPACITY;
    if (!args.isEnabled || blue === undefined || green === undefined || red === undefined) {
        return "rgba(".concat(DEFAULT_NODE_RED_FILL, ", ").concat(DEFAULT_NODE_GREEN_FILL, ", ").concat(DEFAULT_NODE_BLUE_FILL, ", ").concat(opacity, ")");
    }
    return "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", ").concat(opacity, ")");
}
export function getNodeShapeStrokeColor(args) {
    var _a, _b, _c, _d, _e, _f;
    var blue = (_b = (_a = args.dmnStyle) === null || _a === void 0 ? void 0 : _a["dmndi:StrokeColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"];
    var green = (_d = (_c = args.dmnStyle) === null || _c === void 0 ? void 0 : _c["dmndi:StrokeColor"]) === null || _d === void 0 ? void 0 : _d["@_green"];
    var red = (_f = (_e = args.dmnStyle) === null || _e === void 0 ? void 0 : _e["dmndi:StrokeColor"]) === null || _f === void 0 ? void 0 : _f["@_red"];
    if (!args.isEnabled || blue === undefined || green === undefined || red === undefined) {
        return DEFAULT_NODE_STROKE_COLOR;
    }
    return "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", 1)");
}
export function getDmnFontStyle(args) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
    var blue = (_b = (_a = args.dmnStyle) === null || _a === void 0 ? void 0 : _a["dmndi:FontColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"];
    var green = (_d = (_c = args.dmnStyle) === null || _c === void 0 ? void 0 : _c["dmndi:FontColor"]) === null || _d === void 0 ? void 0 : _d["@_green"];
    var red = (_f = (_e = args.dmnStyle) === null || _e === void 0 ? void 0 : _e["dmndi:FontColor"]) === null || _f === void 0 ? void 0 : _f["@_red"];
    var fontColor = !args.isEnabled || blue === undefined || green === undefined || red === undefined
        ? DEFAULT_FONT_COLOR
        : "rgba(".concat(red, ", ").concat(green, ", ").concat(blue, ", 1)");
    return {
        bold: args.isEnabled ? (_h = (_g = args.dmnStyle) === null || _g === void 0 ? void 0 : _g["@_fontBold"]) !== null && _h !== void 0 ? _h : false : false,
        italic: args.isEnabled ? (_k = (_j = args.dmnStyle) === null || _j === void 0 ? void 0 : _j["@_fontItalic"]) !== null && _k !== void 0 ? _k : false : false,
        underline: args.isEnabled ? (_m = (_l = args.dmnStyle) === null || _l === void 0 ? void 0 : _l["@_fontUnderline"]) !== null && _m !== void 0 ? _m : false : false,
        strikeThrough: args.isEnabled ? (_p = (_o = args.dmnStyle) === null || _o === void 0 ? void 0 : _o["@_fontStrikeThrough"]) !== null && _p !== void 0 ? _p : false : false,
        family: args.isEnabled ? (_q = args.dmnStyle) === null || _q === void 0 ? void 0 : _q["@_fontFamily"] : undefined,
        size: args.isEnabled ? (_r = args.dmnStyle) === null || _r === void 0 ? void 0 : _r["@_fontSize"] : undefined,
        color: fontColor,
    };
}
export function getFontCssProperties(dmnFontStyle) {
    var _a, _b, _c;
    var textDecoration = "";
    if (dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.underline) {
        textDecoration += "underline ";
    }
    if (dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.strikeThrough) {
        textDecoration += "line-through";
    }
    return {
        fontWeight: (dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.bold) ? "bold" : "",
        fontStyle: (dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.italic) ? "italic" : "",
        fontFamily: (_a = dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.family) !== null && _a !== void 0 ? _a : "arial",
        textDecoration: textDecoration,
        fontSize: (_b = dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.size) !== null && _b !== void 0 ? _b : "16px",
        color: (_c = dmnFontStyle === null || dmnFontStyle === void 0 ? void 0 : dmnFontStyle.color) !== null && _c !== void 0 ? _c : "black",
        lineHeight: "1.5em",
    };
}
export function getNodeLabelPosition(_a) {
    var nodeType = _a.nodeType, isAlternativeInputDataShape = _a.isAlternativeInputDataShape;
    switch (nodeType) {
        case NODE_TYPES.inputData:
            if (isAlternativeInputDataShape) {
                return "center-bottom";
            }
            return "center-center";
        case NODE_TYPES.decision:
            return "center-center";
        case NODE_TYPES.bkm:
            return "center-center";
        case NODE_TYPES.decisionService:
            return "top-center";
        case NODE_TYPES.knowledgeSource:
            return "center-left";
        case NODE_TYPES.textAnnotation:
            return "top-left";
        case NODE_TYPES.group:
            return "top-left";
        case NODE_TYPES.unknown:
            return "center-center";
        default:
            assertUnreachable(nodeType);
    }
}
export function assertUnreachable(_x) {
    throw new Error("Didn't expect to get here: " + _x);
}
//# sourceMappingURL=NodeStyle.js.map