var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useRef } from "react";
import * as RF from "reactflow";
import { DEFAULT_INTRACTION_WIDTH } from "../maths/DmnMaths";
import { propsHaveSameValuesDeep } from "../memoization/memoization";
import { useIsHovered } from "../useIsHovered";
import { PotentialWaypoint, Waypoints } from "./Waypoints";
import { useAlwaysVisibleEdgeUpdatersAtNodeBorders } from "./useAlwaysVisibleEdgeUpdatersAtNodeBorders";
import { useKieEdgePath } from "./useKieEdgePath";
import { usePotentialWaypointControls } from "./usePotentialWaypointControls";
export var InformationRequirementPath = React.memo(function (_props) {
    var svgRef = _props.svgRef, props = __rest(_props, ["svgRef"]);
    return (_jsx(_Fragment, { children: _jsx("path", __assign({ ref: svgRef, style: { strokeWidth: 1, stroke: "black" }, markerEnd: "url(#closed-arrow)" }, props)) }));
});
export var KnowledgeRequirementPath = React.memo(function (__props) {
    var svgRef = __props.svgRef, props = __rest(__props, ["svgRef"]);
    return (_jsx(_Fragment, { children: _jsx("path", __assign({ ref: svgRef, style: { strokeWidth: 1, stroke: "black", strokeDasharray: "5,5" }, markerEnd: "url(#open-arrow)" }, props)) }));
});
export var AuthorityRequirementPath = React.memo(function (__props) {
    var center = __props.centerToConnectionPoint, svgRef = __props.svgRef, props = __rest(__props, ["centerToConnectionPoint", "svgRef"]);
    return (_jsx(_Fragment, { children: _jsx("path", __assign({ ref: svgRef, style: { strokeWidth: 1, stroke: "black", strokeDasharray: "5,5" }, markerEnd: center ? "url(#closed-circle-at-center)" : "url(#closed-circle-at-border)" }, props)) }));
});
export var AssociationPath = React.memo(function (__props) {
    var _a;
    var strokeWidth = (_a = __props.strokeWidth) !== null && _a !== void 0 ? _a : 1.5;
    var svgRef = __props.svgRef, props = __rest(__props, ["svgRef"]);
    return (_jsx(_Fragment, { children: _jsx("path", __assign({ ref: svgRef, strokeWidth: strokeWidth, strokeLinecap: "butt", strokeLinejoin: "round", style: { stroke: "black", strokeDasharray: "".concat(strokeWidth, ",10") } }, props)) }));
});
export function useEdgeClassName(isConnecting, isDraggingWaypoint) {
    if (isConnecting) {
        return "dimmed";
    }
    if (isDraggingWaypoint) {
        return "dragging-waypoint";
    }
    return "normal";
}
var interactionStrokeProps = {
    strokeOpacity: 1,
    markerEnd: undefined,
    style: undefined,
    className: "react-flow__edge-interaction",
    stroke: "transparent",
    strokeLinecap: "round",
};
export var InformationRequirementEdge = React.memo(function (props) {
    var _a, _b, _c, _d;
    var renderCount = useRef(0);
    renderCount.current++;
    var _e = useKieEdgePath(props.source, props.target, props.data), path = _e.path, waypoints = _e.points;
    var interactionPathRef = React.useRef(null);
    var isHovered = useIsHovered(interactionPathRef);
    var _f = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef), onMouseMove = _f.onMouseMove, onDoubleClick = _f.onDoubleClick, potentialWaypoint = _f.potentialWaypoint, isDraggingWaypoint = _f.isDraggingWaypoint;
    var isConnecting = !!RF.useStore(function (s) { return s.connectionNodeId; });
    var className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(InformationRequirementPath, __assign({ svgRef: interactionPathRef, d: path }, interactionStrokeProps, { className: "".concat(interactionStrokeProps.className, " ").concat(className), strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "information-requirement" })), _jsx(InformationRequirementPath, { d: path, className: "kie-dmn-editor--edge ".concat(className) }), props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export var KnowledgeRequirementEdge = React.memo(function (props) {
    var _a, _b, _c, _d;
    var renderCount = useRef(0);
    renderCount.current++;
    var _e = useKieEdgePath(props.source, props.target, props.data), path = _e.path, waypoints = _e.points;
    var interactionPathRef = React.useRef(null);
    var isHovered = useIsHovered(interactionPathRef);
    var _f = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef), onMouseMove = _f.onMouseMove, onDoubleClick = _f.onDoubleClick, potentialWaypoint = _f.potentialWaypoint, isDraggingWaypoint = _f.isDraggingWaypoint;
    var isConnecting = !!RF.useStore(function (s) { return s.connectionNodeId; });
    var className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(KnowledgeRequirementPath, __assign({ svgRef: interactionPathRef, d: path }, interactionStrokeProps, { className: "".concat(interactionStrokeProps.className, " ").concat(className), strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "knowledge-requirement" })), _jsx(KnowledgeRequirementPath, { d: path, className: "kie-dmn-editor--edge ".concat(className) }), props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export var AuthorityRequirementEdge = React.memo(function (props) {
    var _a, _b, _c, _d;
    var renderCount = useRef(0);
    renderCount.current++;
    var _e = useKieEdgePath(props.source, props.target, props.data), path = _e.path, waypoints = _e.points;
    var interactionPathRef = React.useRef(null);
    var isHovered = useIsHovered(interactionPathRef);
    var _f = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef), onMouseMove = _f.onMouseMove, onDoubleClick = _f.onDoubleClick, potentialWaypoint = _f.potentialWaypoint, isDraggingWaypoint = _f.isDraggingWaypoint;
    var isConnecting = !!RF.useStore(function (s) { return s.connectionNodeId; });
    var className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(AuthorityRequirementPath, __assign({ svgRef: interactionPathRef, d: path, centerToConnectionPoint: false }, interactionStrokeProps, { className: "".concat(interactionStrokeProps.className, " ").concat(className), strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "authority-requirement" })), _jsx(AuthorityRequirementPath, { d: path, className: "kie-dmn-editor--edge ".concat(className), centerToConnectionPoint: false }), props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
export var AssociationEdge = React.memo(function (props) {
    var _a, _b, _c, _d;
    var renderCount = useRef(0);
    renderCount.current++;
    var _e = useKieEdgePath(props.source, props.target, props.data), path = _e.path, waypoints = _e.points;
    var interactionPathRef = React.useRef(null);
    var isHovered = useIsHovered(interactionPathRef);
    var _f = usePotentialWaypointControls(waypoints, props.selected, props.id, (_b = (_a = props.data) === null || _a === void 0 ? void 0 : _a.dmnEdge) === null || _b === void 0 ? void 0 : _b.index, interactionPathRef), onMouseMove = _f.onMouseMove, onDoubleClick = _f.onDoubleClick, potentialWaypoint = _f.potentialWaypoint, isDraggingWaypoint = _f.isDraggingWaypoint;
    var isConnecting = !!RF.useStore(function (s) { return s.connectionNodeId; });
    var className = useEdgeClassName(isConnecting, isDraggingWaypoint);
    useAlwaysVisibleEdgeUpdatersAtNodeBorders(interactionPathRef, props.source, props.target, waypoints);
    return (_jsxs(_Fragment, { children: [_jsx(AssociationPath, __assign({ svgRef: interactionPathRef, d: path }, interactionStrokeProps, { className: "".concat(interactionStrokeProps.className, " ").concat(className), strokeWidth: (_c = props.interactionWidth) !== null && _c !== void 0 ? _c : DEFAULT_INTRACTION_WIDTH, onMouseMove: onMouseMove, onDoubleClick: onDoubleClick, "data-edgetype": "association" })), _jsx(AssociationPath, { d: path, className: "kie-dmn-editor--edge ".concat(className) }), props.selected && !isConnecting && ((_d = props.data) === null || _d === void 0 ? void 0 : _d.dmnEdge) && (_jsx(Waypoints, { edgeId: props.id, edgeIndex: props.data.dmnEdge.index, waypoints: waypoints, onDragStop: onMouseMove })), isHovered && potentialWaypoint && _jsx(PotentialWaypoint, { point: potentialWaypoint.point })] }));
}, propsHaveSameValuesDeep);
//# sourceMappingURL=Edges.js.map