var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as RF from "reactflow";
import * as React from "react";
import { useCallback } from "react";
import { NODE_TYPES } from "./nodes/NodeTypes";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { addStandaloneNode } from "../mutations/addStandaloneNode";
import { CONTAINER_NODES_DESIRABLE_PADDING, getBounds } from "./maths/DmnMaths";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { ExternalNodesPanel } from "../externalNodes/ExternalNodesPanel";
import { MigrationIcon } from "@patternfly/react-icons/dist/js/icons/migration-icon";
import { AlternativeInputDataIcon, BkmIcon, DecisionIcon, DecisionServiceIcon, GroupIcon, InputDataIcon, KnowledgeSourceIcon, TextAnnotationIcon, } from "../icons/Icons";
import { DrdSelectorPanel } from "./DrdSelectorPanel";
import { addOrGetDrd, getDefaultDrdName } from "../mutations/addOrGetDrd";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { BarsIcon } from "@patternfly/react-icons/dist/js/icons/bars-icon";
import { DrgNodesPanel } from "./DrgNodesPanel";
import { CaretDownIcon } from "@patternfly/react-icons/dist/js/icons/caret-down-icon";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useDmnEditor } from "../DmnEditorContext";
import { getDrdId } from "./drd/drdId";
export var MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE = "application/kie-dmn-editor--new-node-from-palette";
export function Palette(_a) {
    var _b, _c, _d;
    var pulse = _a.pulse;
    var onDragStart = useCallback(function (event, nodeType) {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE, nodeType);
        event.dataTransfer.effectAllowed = "move";
    }, []);
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn.model; });
    var rfStoreApi = RF.useStoreApi();
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var drdIndex = useDmnEditorStore(function (s) { return s.computed(s).getDrdIndex(); });
    var groupNodes = useCallback(function () {
        dmnEditorStoreApi.setState(function (state) {
            var selectedNodes = rfStoreApi
                .getState()
                .getNodes()
                .filter(function (s) { return s.selected; });
            if (selectedNodes.length <= 0) {
                return;
            }
            var newNodeId = addStandaloneNode({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                newNode: {
                    type: NODE_TYPES.group,
                    bounds: getBounds({
                        nodes: selectedNodes,
                        padding: CONTAINER_NODES_DESIRABLE_PADDING,
                    }),
                },
            }).href;
            state.dispatch(state).diagram.setNodeStatus(newNodeId, { selected: true });
        });
    }, [dmnEditorStoreApi, rfStoreApi]);
    var drd = (_c = (_b = thisDmn.definitions["dmndi:DMNDI"]) === null || _b === void 0 ? void 0 : _b["dmndi:DMNDiagram"]) === null || _c === void 0 ? void 0 : _c[drdIndex];
    var drdSelectorPopoverRef = React.useRef(null);
    var nodesPalletePopoverRef = React.useRef(null);
    var maxHeight = useInViewSelect(dmnEditorRootElementRef, nodesPalletePopoverRef).maxHeight;
    return (_jsxs(_Fragment, { children: [_jsx(RF.Panel, __assign({ position: "top-left" }, { children: _jsxs("aside", __assign({ className: "kie-dmn-editor--drd-selector", style: { position: "relative" } }, { children: [_jsx("div", { ref: drdSelectorPopoverRef, style: { position: "absolute", left: "56px", height: "100%", zIndex: -1 } }), _jsx(InlineFeelNameInput, { validate: function () { return true; }, allUniqueNames: function () { return new Map(); }, name: (_d = drd === null || drd === void 0 ? void 0 : drd["@_name"]) !== null && _d !== void 0 ? _d : "", prefix: "".concat(drdIndex + 1, "."), id: getDrdId({ drdIndex: drdIndex }), onRenamed: function (newName) {
                                dmnEditorStoreApi.setState(function (state) {
                                    var drd = addOrGetDrd({
                                        definitions: state.dmn.model.definitions,
                                        drdIndex: state.computed(state).getDrdIndex(),
                                    });
                                    drd.diagram["@_name"] = newName;
                                });
                            }, placeholder: getDefaultDrdName({ drdIndex: drdIndex }), isReadonly: false, isPlain: true, shouldCommitOnBlur: true }), _jsx(Popover, { className: "kie-dmn-editor--drd-selector-popover", "aria-label": "DRD Selector Popover", isVisible: diagram.openLhsPanel === DiagramLhsPanel.DRD_SELECTOR, reference: function () { return drdSelectorPopoverRef.current; }, shouldClose: function () {
                                dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                });
                            }, position: "bottom-start", hideOnOutsideClick: false, bodyContent: _jsx(DrdSelectorPanel, {}) }, DiagramLhsPanel.DRD_SELECTOR), _jsx("button", __assign({ title: "Select or edit DRD", onClick: function () {
                                dmnEditorStoreApi.setState(function (state) {
                                    state.diagram.openLhsPanel =
                                        state.diagram.openLhsPanel === DiagramLhsPanel.DRD_SELECTOR
                                            ? DiagramLhsPanel.NONE
                                            : DiagramLhsPanel.DRD_SELECTOR;
                                });
                            } }, { children: _jsx(CaretDownIcon, {}) }))] })) })), _jsxs(RF.Panel, __assign({ position: "top-left", style: { marginTop: "78px" } }, { children: [_jsx("div", { ref: nodesPalletePopoverRef, style: { position: "absolute", left: 0, height: 0, zIndex: -1 } }), _jsxs("aside", __assign({ className: "kie-dmn-editor--palette ".concat(pulse ? "pulse" : "") }, { children: [_jsx("div", __assign({ title: "Input Data", className: "kie-dmn-editor--palette-button dndnode input-data", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.inputData); }, draggable: true }, { children: isAlternativeInputDataShape ? _jsx(AlternativeInputDataIcon, {}) : _jsx(InputDataIcon, {}) })), _jsx("div", __assign({ title: "Decision", className: "kie-dmn-editor--palette-button dndnode decision", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.decision); }, draggable: true }, { children: _jsx(DecisionIcon, {}) })), _jsx("div", __assign({ title: "Business Knowledge Model", className: "kie-dmn-editor--palette-button dndnode bkm", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.bkm); }, draggable: true }, { children: _jsx(BkmIcon, {}) })), _jsx("div", __assign({ title: "Knowledge Source", className: "kie-dmn-editor--palette-button dndnode knowledge-source", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.knowledgeSource); }, draggable: true }, { children: _jsx(KnowledgeSourceIcon, {}) })), _jsx("div", __assign({ title: "Decision Service", className: "kie-dmn-editor--palette-button dndnode decision-service", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.decisionService); }, draggable: true }, { children: _jsx(DecisionServiceIcon, {}) }))] })), _jsx("br", {}), _jsxs("aside", __assign({ className: "kie-dmn-editor--palette ".concat(pulse ? "pulse" : "") }, { children: [_jsx("div", __assign({ title: "Group", className: "kie-dmn-editor--palette-button dndnode group", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.group); }, draggable: true, onClick: groupNodes }, { children: _jsx(GroupIcon, {}) })), _jsx("div", __assign({ title: "Text Annotation", className: "kie-dmn-editor--palette-button dndnode text-annotation", onDragStart: function (event) { return onDragStart(event, NODE_TYPES.textAnnotation); }, draggable: true }, { children: _jsx(TextAnnotationIcon, {}) }))] })), _jsx("br", {}), _jsxs("aside", __assign({ className: "kie-dmn-editor--drg-panel-toggle" }, { children: [diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES && (_jsx("div", __assign({ className: "kie-dmn-editor--palette-nodes-popover", style: { maxHeight: maxHeight } }, { children: _jsx(DrgNodesPanel, {}) }))), _jsx("button", __assign({ title: "DRG nodes", className: "kie-dmn-editor--drg-panel-toggle-button ".concat(diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES ? "active" : ""), onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        state.diagram.openLhsPanel =
                                            state.diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES
                                                ? DiagramLhsPanel.NONE
                                                : DiagramLhsPanel.DRG_NODES;
                                    });
                                } }, { children: _jsx(BarsIcon, { size: "sm" }) }))] })), _jsx("br", {}), _jsxs("aside", __assign({ className: "kie-dmn-editor--external-nodes-panel-toggle" }, { children: [diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES && (_jsx("div", __assign({ className: "kie-dmn-editor--palette-nodes-popover", style: { maxHeight: maxHeight } }, { children: _jsx(ExternalNodesPanel, {}) }))), _jsx("button", __assign({ title: "External nodes", className: "kie-dmn-editor--external-nodes-panel-toggle-button ".concat(diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES ? "active" : ""), onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        state.diagram.openLhsPanel =
                                            state.diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES
                                                ? DiagramLhsPanel.NONE
                                                : DiagramLhsPanel.EXTERNAL_NODES;
                                    });
                                } }, { children: _jsx(MigrationIcon, { size: "sm" }) }))] }))] }))] }));
}
//# sourceMappingURL=Palette.js.map