var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import * as React from "react";
import { useCallback, useMemo, useState } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { TypeRefSelector } from "./TypeRefSelector";
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { DataTypeName } from "./DataTypeName";
import { ItemComponentsTable } from "./ItemComponentsTable";
import { getNewItemDefinition, isStruct } from "./DataTypeSpec";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { CopyIcon } from "@patternfly/react-icons/dist/js/icons/copy-icon";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { buildClipboardFromDataType } from "../clipboard/Clipboard";
import { ConstraintsFromAllowedValuesAttribute, ConstraintsFromTypeConstraintAttribute } from "./Constraints";
import { original } from "immer";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "./useResolvedTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { InfoAltIcon } from "@patternfly/react-icons/dist/js/icons/info-alt-icon";
export function DataTypePanel(_a) {
    var _b, _c;
    var isReadonly = _a.isReadonly, dataType = _a.dataType, allDataTypesById = _a.allDataTypesById, editItemDefinition = _a.editItemDefinition;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var toggleStruct = useCallback(function (isChecked) {
        if (isReadonly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], function (itemDefinition) {
            if (isChecked) {
                itemDefinition.typeRef = undefined;
                itemDefinition.itemComponent = [];
                itemDefinition.typeConstraint = undefined;
                itemDefinition.allowedValues = undefined;
            }
            else {
                itemDefinition.typeRef = { __$$text: DmnBuiltInDataType.Any };
                itemDefinition.itemComponent = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadonly]);
    var toggleCollection = useCallback(function (isChecked) {
        if (isReadonly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], function (itemDefinition) {
            itemDefinition["@_isCollection"] = isChecked;
            if (isChecked === true) {
                itemDefinition.allowedValues = itemDefinition.typeConstraint
                    ? __assign({}, itemDefinition.typeConstraint) : undefined;
                itemDefinition.typeConstraint = undefined;
            }
            else {
                itemDefinition.typeConstraint = itemDefinition.allowedValues
                    ? __assign({}, itemDefinition.allowedValues) : undefined;
                itemDefinition.allowedValues = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadonly]);
    var changeTypeRef = useCallback(function (typeRef) {
        if (isReadonly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], function (itemDefinition) {
            var _a;
            itemDefinition.typeRef = typeRef ? { __$$text: typeRef } : undefined;
            var originalItemDefinition = original(itemDefinition);
            if (((_a = originalItemDefinition === null || originalItemDefinition === void 0 ? void 0 : originalItemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== typeRef) {
                itemDefinition.typeConstraint = undefined;
                itemDefinition.allowedValues = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadonly]);
    var changeDescription = useCallback(function (newDescription) {
        if (isReadonly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], function (itemDefinition) {
            itemDefinition.description = { __$$text: newDescription };
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadonly]);
    var parents = useMemo(function () {
        var parents = [];
        var cur = dataType;
        while (cur.parentId) {
            var p = allDataTypesById.get(cur.parentId);
            parents.unshift(p);
            cur = p;
        }
        return parents;
    }, [dataType, allDataTypesById]);
    var addItemComponent = useCallback(function (id, how, partial) {
        if (isReadonly) {
            return;
        }
        editItemDefinition(id, function (itemDefinition, items, index, all, state) {
            var _a;
            var newItemDefinition = getNewItemDefinition(partial);
            (_a = itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : (itemDefinition.itemComponent = []);
            itemDefinition.itemComponent[how](newItemDefinition);
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [editItemDefinition, isReadonly]);
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _d = __read(useState(undefined), 2), dropdownOpenFor = _d[0], setDropdownOpenFor = _d[1];
    var _e = __read(useState(false), 2), topLevelDropdownOpen = _e[0], setTopLevelDropdownOpen = _e[1];
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var allTopLevelItemDefinitionUniqueNames = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames; });
    var _f = __read(useState(false), 2), isCollectionConstraintPopoverOpen = _f[0], setIsCollectionConstraintPopoverOpen = _f[1];
    var _g = __read(useState(false), 2), isCollectionItemConstraintPopoverOpen = _g[0], setIsCollectionItemConstraintPopoverOpen = _g[1];
    var allUniqueNames = useMemo(function () {
        var _a;
        return !dataType.parentId
            ? allTopLevelItemDefinitionUniqueNames
            : ((_a = allDataTypesById.get(dataType.parentId).itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : []).reduce(function (acc, s) { return acc.set(s["@_name"], s["@_id"]); }, new Map(__spreadArray([], __read(builtInFeelTypeNames), false).map(function (s) { return [s, s]; })));
    }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, dataType.parentId]);
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var resolvedTypeRef = useResolvedTypeRef((_b = dataType.itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text, dataType.namespace);
    return (_jsxs(_Fragment, { children: [_jsxs(Flex, __assign({ className: "kie-dmn-editor--sticky-top-glass-header kie-dmn-editor--data-type-panel-header ".concat(parents.length > 0 || dataType.namespace !== thisDmnsNamespace
                    ? "kie-dmn-editor--data-type-panel-header-nested-or-external"
                    : ""), justifyContent: { default: "justifyContentSpaceBetween" }, direction: { default: "row" } }, { children: [_jsx(FlexItem, { children: _jsxs(Flex, __assign({ direction: { default: "column" } }, { children: [_jsx(FlexItem, { children: _jsxs(Flex, __assign({ direction: { default: "row" } }, { children: [dataType.namespace !== thisDmnsNamespace && (_jsx(FlexItem, { children: _jsx(Label, { children: "External" }) })), parents.length > 0 && (_jsx(FlexItem, __assign({ className: "kie-dmn-editor--data-type-parents" }, { children: parents.map(function (p) { return (_jsx(Button, __assign({ variant: ButtonVariant.link, onClick: function () {
                                                        dmnEditorStoreApi.setState(function (state) {
                                                            state.dataTypesEditor.activeItemDefinitionId = p.itemDefinition["@_id"];
                                                        });
                                                    } }, { children: buildFeelQNameFromNamespace({
                                                        namedElement: p.itemDefinition,
                                                        importsByNamespace: importsByNamespace,
                                                        namespace: p.namespace,
                                                        relativeToNamespace: !p.parentId ? thisDmnsNamespace : p.namespace,
                                                    }).full }), p.itemDefinition["@_id"])); }) })))] })) }), _jsx(FlexItem, { children: _jsx("div", __assign({ className: "kie-dmn-editor--data-types-title" }, { children: _jsx(DataTypeName, { relativeToNamespace: !dataType.parentId ? thisDmnsNamespace : dataType.namespace, itemDefinition: dataType.itemDefinition, isActive: false, editMode: "hover", isReadonly: dataType.namespace !== thisDmnsNamespace, onGetAllUniqueNames: function () { return allUniqueNames; } }) })) })] })) }), _jsx(FlexItem, { children: _jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-top-level", onToggle: setTopLevelDropdownOpen }), onSelect: function () { return setTopLevelDropdownOpen(false); }, isOpen: topLevelDropdownOpen, menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                _jsx(DropdownItem, __assign({ isDisabled: true, icon: _jsx(_Fragment, {}) }, { children: _jsxs("div", { children: [_jsx("b", { children: "ID: " }), dataType.itemDefinition["@_id"]] }) }), "id"),
                                _jsx(DropdownSeparator, { style: { marginBottom: "8px" } }, "separator-1"),
                                _jsx(DropdownItem, __assign({ icon: _jsx(CopyIcon, {}), onClick: function () {
                                        var clipboard = buildClipboardFromDataType(dataType, thisDmnsNamespace);
                                        navigator.clipboard.writeText(JSON.stringify(clipboard));
                                    } }, { children: "Copy" }), "copy"),
                                _jsx(DropdownSeparator, {}, "separator-2"),
                                _jsx(React.Fragment, { children: !isReadonly && (_jsx(DropdownItem, __assign({ style: { minWidth: "240px" }, icon: _jsx(TrashIcon, {}), onClick: function () {
                                            if (isReadonly) {
                                                return;
                                            }
                                            editItemDefinition(dataType.itemDefinition["@_id"], function (_, items) {
                                                items === null || items === void 0 ? void 0 : items.splice(dataType.index, 1);
                                            });
                                            dmnEditorStoreApi.setState(function (state) {
                                                var _a, _b, _c;
                                                state.dataTypesEditor.activeItemDefinitionId =
                                                    (_a = dataType.parentId) !== null && _a !== void 0 ? _a : (_c = (_b = state.dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c["@_id"];
                                            });
                                        } }, { children: "Remove" }))) }, "remove-fragment"),
                            ] }) })] })), _jsxs(PageSection, __assign({ style: { padding: "24px" } }, { children: [_jsx(TextArea, { isDisabled: isReadonly, value: (_c = dataType.itemDefinition.description) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: changeDescription, placeholder: "Enter a description...", resizeOrientation: "vertical", "aria-label": "Data type description" }, dataType.itemDefinition["@_id"]), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsx(Switch, { label: "Is collection?", isChecked: !!dataType.itemDefinition["@_isCollection"], onChange: toggleCollection }), _jsx("br", {}), _jsx("br", {}), _jsx(Switch, { label: "Is struct?", isChecked: isStruct(dataType.itemDefinition), onChange: toggleStruct }), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), !isStruct(dataType.itemDefinition) && (_jsxs(_Fragment, { children: [_jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "Type" })), _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, isDisabled: isReadonly, typeRef: resolvedTypeRef, onChange: changeTypeRef, removeDataTypes: [dataType] }), _jsx("br", {}), _jsx("br", {}), dataType.itemDefinition["@_isCollection"] === true ? (_jsxs(_Fragment, { children: [_jsxs(Flex, __assign({ direction: { default: "row" }, alignItems: { default: "alignItemsCenter" } }, { children: [_jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "Collection constraint" })), _jsx(Popover, __assign({ isVisible: isCollectionConstraintPopoverOpen, shouldClose: function () { return setIsCollectionConstraintPopoverOpen(false); }, headerContent: "Collection Constraints (Type Constraint)", headerIcon: _jsx(InfoAltIcon, {}), headerComponent: "h1", bodyContent: _jsxs("p", { children: ["As per the DMN specification, the ", _jsx("b", { children: "Type Constraint" }), " attribute lists the possible values", _jsx("br", {}), "or ranges of values in the base type that are allowed in this ItemDefinition."] }) }, { children: _jsx(InfoAltIcon, { onMouseEnter: function () { return setIsCollectionConstraintPopoverOpen(true); }, onMouseLeave: function () { return setIsCollectionConstraintPopoverOpen(false); } }) }))] })), _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: isReadonly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition, defaultsToAllowedValues: false }), _jsx("br", {}), _jsx("br", {}), _jsxs(Flex, __assign({ direction: { default: "row" }, alignItems: { default: "alignItemsCenter" } }, { children: [_jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "Collection item constraint" })), _jsx(Popover, __assign({ isVisible: isCollectionItemConstraintPopoverOpen, shouldClose: function () { return setIsCollectionItemConstraintPopoverOpen(false); }, headerContent: "Collection Item Constraints (Allowed Values)", headerIcon: _jsx(InfoAltIcon, {}), headerComponent: "h1", bodyContent: _jsxs("p", { children: ["As per the DMN specification, the ", _jsx("b", { children: "Allowed Values" }), " attribute lists the possible values", _jsx("br", {}), "or ranges of values in the base type that are allowed in this ItemDefinition."] }) }, { children: _jsx(InfoAltIcon, { onMouseEnter: function () { return setIsCollectionItemConstraintPopoverOpen(true); }, onMouseLeave: function () { return setIsCollectionItemConstraintPopoverOpen(false); } }) }))] })), _jsx(Alert, __assign({ variant: "warning", isInline: true, isPlain: true, title: "Deprecated" }, { children: _jsx("p", { children: "Creating constraints for the collection items directly on the collection itself is deprecated since DMN 1.5 and will possibly be removed in future versions. To prepare your DMN model for future updates, please create a dedicated Data Type for the items of this list and add constraints there." }) })), _jsx("br", {}), _jsx(ConstraintsFromAllowedValuesAttribute, { isReadonly: isReadonly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition })] })) : (_jsxs(_Fragment, { children: [_jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "Constraints" })), _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: isReadonly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition, defaultsToAllowedValues: true })] }))] })), isStruct(dataType.itemDefinition) && (_jsx(ItemComponentsTable, { isReadonly: isReadonly, addItemComponent: addItemComponent, allDataTypesById: allDataTypesById, parent: dataType, editItemDefinition: editItemDefinition, dropdownOpenFor: dropdownOpenFor, setDropdownOpenFor: setDropdownOpenFor }))] }))] }));
}
//# sourceMappingURL=DataTypePanel.js.map