var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useMemo, useRef } from "react";
var DmnEditorContext = React.createContext({});
export function useDmnEditor() {
    return useContext(DmnEditorContext);
}
export function DmnEditorContextProvider(props) {
    var dmnModelBeforeEditingRef = useRef(props.model);
    var dmnEditorRootElementRef = useRef(null);
    var value = useMemo(function () { return ({
        dmnModelBeforeEditingRef: dmnModelBeforeEditingRef,
        dmnEditorRootElementRef: dmnEditorRootElementRef,
        externalContextDescription: props.externalContextDescription,
        externalContextName: props.externalContextName,
        issueTrackerHref: props.issueTrackerHref,
        onRequestToJumpToPath: props.onRequestToJumpToPath,
        onRequestToResolvePath: props.onRequestToResolvePath,
    }); }, [
        props.externalContextDescription,
        props.externalContextName,
        props.issueTrackerHref,
        props.onRequestToJumpToPath,
        props.onRequestToResolvePath,
    ]);
    return _jsx(DmnEditorContext.Provider, __assign({ value: value }, { children: props.children }));
}
//# sourceMappingURL=DmnEditorContext.js.map