var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import "@patternfly/react-core/dist/styles/base.css";
import "reactflow/dist/style.css";
import * as React from "react";
import * as ReactDOM from "react-dom";
import * as RF from "reactflow";
import { ErrorBoundary } from "react-error-boundary";
import { useCallback, useEffect, useImperativeHandle, useMemo, useRef, useState } from "react";
import { original } from "immer";
import { FileIcon } from "@patternfly/react-icons/dist/js/icons/file-icon";
import { InfrastructureIcon } from "@patternfly/react-icons/dist/js/icons/infrastructure-icon";
import { PficonTemplateIcon } from "@patternfly/react-icons/dist/js/icons/pficon-template-icon";
import { Drawer, DrawerContent, DrawerContentBody } from "@patternfly/react-core/dist/js/components/Drawer";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Tab, TabTitleIcon, TabTitleText, Tabs } from "@patternfly/react-core/dist/js/components/Tabs";
import { BoxedExpressionScreen } from "./boxedExpressions/BoxedExpressionScreen";
import { DataTypes } from "./dataTypes/DataTypes";
import { Diagram } from "./diagram/Diagram";
import { DmnVersionLabel } from "./diagram/DmnVersionLabel";
import { normalize } from "./normalization/normalize";
import { BoxedExpressionPropertiesPanel } from "./propertiesPanel/BoxedExpressionPropertiesPanel";
import { DmnEditorContextProvider, useDmnEditor } from "./DmnEditorContext";
import { DmnEditorErrorFallback } from "./DmnEditorErrorFallback";
import { DmnEditorExternalModelsContextProvider, useExternalModels, } from "./includedModels/DmnEditorDependenciesContext";
import { IncludedModels } from "./includedModels/IncludedModels";
import { DiagramPropertiesPanel } from "./propertiesPanel/DiagramPropertiesPanel";
import { ComputedStateCache } from "./store/ComputedStateCache";
import { DmnEditorTab, createDmnEditorStore, defaultStaticState } from "./store/Store";
import { DmnEditorStoreApiContext, useDmnEditorStore, useDmnEditorStoreApi } from "./store/StoreContext";
import { DmnDiagramSvg } from "./svg/DmnDiagramSvg";
import { useEffectAfterFirstRender } from "./useEffectAfterFirstRender";
import { INITIAL_COMPUTED_CACHE } from "./store/computed/initial";
import "@kie-tools/dmn-marshaller/dist/kie-extensions";
import "./DmnEditor.css";
import { CommandsContextProvider, useCommands } from "./commands/CommandsContextProvider";
var ON_MODEL_CHANGE_DEBOUNCE_TIME_IN_MS = 500;
var SVG_PADDING = 20;
export var DmnEditorInternal = function (_a) {
    var _b, _c;
    var model = _a.model, originalVersion = _a.originalVersion, onModelChange = _a.onModelChange, onModelDebounceStateChanged = _a.onModelDebounceStateChanged, forwardRef = _a.forwardRef;
    var boxedExpressionEditorActiveDrgElementId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.activeDrgElementId; });
    var isBeePropertiesPanelOpen = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.propertiesPanel.isOpen; });
    var isDiagramPropertiesPanelOpen = useDmnEditorStore(function (s) { return s.diagram.propertiesPanel.isOpen; });
    var navigationTab = useDmnEditorStore(function (s) { return s.navigation.tab; });
    var dmn = useDmnEditorStore(function (s) { return s.dmn; });
    var isDiagramEditingInProgress = useDmnEditorStore(function (s) { return s.computed(s).isDiagramEditingInProgress(); });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var commandsRef = useCommands().commandsRef;
    var _d = useDmnEditor(), dmnModelBeforeEditingRef = _d.dmnModelBeforeEditingRef, dmnEditorRootElementRef = _d.dmnEditorRootElementRef;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var diagramRef = useRef(null);
    var diagramContainerRef = useRef(null);
    var beeContainerRef = useRef(null);
    useImperativeHandle(forwardRef, function () { return ({
        reset: function (model) {
            var state = dmnEditorStoreApi.getState();
            return state.dispatch(state).dmn.reset(normalize(model));
        },
        getDiagramSvg: function () { return __awaiter(void 0, void 0, void 0, function () {
            var nodes, edges, bounds, state, svg;
            var _a, _b, _c, _d;
            return __generator(this, function (_e) {
                nodes = (_b = (_a = diagramRef.current) === null || _a === void 0 ? void 0 : _a.getReactFlowInstance()) === null || _b === void 0 ? void 0 : _b.getNodes();
                edges = (_d = (_c = diagramRef.current) === null || _c === void 0 ? void 0 : _c.getReactFlowInstance()) === null || _d === void 0 ? void 0 : _d.getEdges();
                if (!nodes || !edges) {
                    return [2, undefined];
                }
                bounds = RF.getNodesBounds(nodes);
                state = dmnEditorStoreApi.getState();
                svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
                svg.setAttribute("width", bounds.width + SVG_PADDING * 2 + "");
                svg.setAttribute("height", bounds.height + (state.computed(state).isAlternativeInputDataShape() ? SVG_PADDING * 5 : SVG_PADDING * 2) + "");
                ReactDOM.render(_jsx("g", __assign({ transform: "translate(".concat(-bounds.x + SVG_PADDING, " ").concat(-bounds.y + SVG_PADDING, ")") }, { children: _jsx(DmnDiagramSvg, { nodes: nodes, edges: edges, snapGrid: state.diagram.snapGrid, importsByNamespace: state.computed(state).importsByNamespace(), thisDmn: state.dmn, isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(), allDataTypesById: state.computed(state).getDataTypes(externalModelsByNamespace).allDataTypesById, allTopLevelItemDefinitionUniqueNames: state.computed(state).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames }) })), svg);
                return [2, new XMLSerializer().serializeToString(svg)];
            });
        }); },
        getCommands: function () { return commandsRef.current; },
    }); }, [dmnEditorStoreApi, externalModelsByNamespace, commandsRef]);
    useEffectAfterFirstRender(function () {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            if (model === original(state.dmn.model)) {
                return;
            }
            state.diagram.autoLayout.canAutoGenerateDrd =
                ((_a = model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === undefined &&
                    model.definitions.drgElement !== undefined;
            state.dmn.model = normalize(model);
            dmnModelBeforeEditingRef.current = state.dmn.model;
        });
    }, [dmnEditorStoreApi, model]);
    useStateAsItWasBeforeConditionBecameTrue(dmn.model, isDiagramEditingInProgress, useCallback(function (prev) { return (dmnModelBeforeEditingRef.current = prev); }, [dmnModelBeforeEditingRef]));
    useEffectAfterFirstRender(function () {
        if (isDiagramEditingInProgress) {
            return;
        }
        onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(false);
        var timeout = setTimeout(function () {
            if (model === dmn.model) {
                return;
            }
            onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(true);
            console.debug("DMN EDITOR: Model changed!");
            onModelChange === null || onModelChange === void 0 ? void 0 : onModelChange(dmn.model);
        }, ON_MODEL_CHANGE_DEBOUNCE_TIME_IN_MS);
        return function () {
            clearTimeout(timeout);
        };
    }, [isDiagramEditingInProgress, onModelChange, dmn.model]);
    var onTabChanged = useCallback(function (e, tab) {
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b, _c;
            state.navigation.tab = tab;
            if (tab === DmnEditorTab.DATA_TYPES) {
                state.dataTypesEditor.activeItemDefinitionId =
                    (_a = state.dataTypesEditor.activeItemDefinitionId) !== null && _a !== void 0 ? _a : (_c = (_b = state.dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c["@_id"];
            }
        });
    }, [dmnEditorStoreApi]);
    var tabTitle = useMemo(function () {
        var _a, _b, _c, _d;
        return {
            editor: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(PficonTemplateIcon, {}) }), _jsx(TabTitleText, { children: "Editor" })] })),
            dataTypes: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(InfrastructureIcon, {}) }), _jsxs(TabTitleText, { children: ["Data types\u00A0\u00A0", _jsx(Label, __assign({ style: { padding: "0 12px" } }, { children: (_b = (_a = dmn.model.definitions.itemDefinition) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0 }))] })] })),
            includedModels: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(FileIcon, {}) }), _jsxs(TabTitleText, { children: ["Included models\u00A0\u00A0", _jsx(Label, __assign({ style: { padding: "0 12px" } }, { children: (_d = (_c = dmn.model.definitions.import) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0 }))] })] })),
        };
    }, [(_b = dmn.model.definitions.import) === null || _b === void 0 ? void 0 : _b.length, (_c = dmn.model.definitions.itemDefinition) === null || _c === void 0 ? void 0 : _c.length]);
    var diagramPropertiesPanel = useMemo(function () { return _jsx(DiagramPropertiesPanel, {}); }, []);
    var beePropertiesPanel = useMemo(function () { return _jsx(BoxedExpressionPropertiesPanel, {}); }, []);
    return (_jsx("div", __assign({ ref: dmnEditorRootElementRef, className: "kie-dmn-editor--root" }, { children: _jsxs(Tabs, __assign({ isFilled: true, activeKey: navigationTab, onSelect: onTabChanged, role: "region", className: "kie-dmn-editor--tabs" }, { children: [_jsx(Tab, __assign({ eventKey: DmnEditorTab.EDITOR, title: tabTitle.editor }, { children: navigationTab === DmnEditorTab.EDITOR && (_jsxs(_Fragment, { children: [!boxedExpressionEditorActiveDrgElementId && (_jsx(Drawer, __assign({ isExpanded: isDiagramPropertiesPanelOpen, isInline: true, position: "right" }, { children: _jsx(DrawerContent, __assign({ panelContent: diagramPropertiesPanel }, { children: _jsx(DrawerContentBody, { children: _jsxs("div", __assign({ className: "kie-dmn-editor--diagram-container", ref: diagramContainerRef, "data-testid": "kie-dmn-editor--diagram-container" }, { children: [originalVersion && _jsx(DmnVersionLabel, { version: originalVersion }), _jsx(Diagram, { ref: diagramRef, container: diagramContainerRef })] })) }) })) }))), boxedExpressionEditorActiveDrgElementId && (_jsx(Drawer, __assign({ isExpanded: isBeePropertiesPanelOpen, isInline: true, position: "right" }, { children: _jsx(DrawerContent, __assign({ panelContent: beePropertiesPanel }, { children: _jsx(DrawerContentBody, { children: _jsx("div", __assign({ className: "kie-dmn-editor--bee-container", ref: beeContainerRef }, { children: _jsx(BoxedExpressionScreen, { container: beeContainerRef }) })) }) })) })))] })) })), _jsx(Tab, __assign({ eventKey: DmnEditorTab.DATA_TYPES, title: tabTitle.dataTypes }, { children: navigationTab === DmnEditorTab.DATA_TYPES && _jsx(DataTypes, {}) })), _jsx(Tab, __assign({ eventKey: DmnEditorTab.INCLUDED_MODELS, title: tabTitle.includedModels }, { children: navigationTab === DmnEditorTab.INCLUDED_MODELS && _jsx(IncludedModels, {}) }))] })) })));
};
export var DmnEditor = React.forwardRef(function (props, ref) {
    var store = useMemo(function () { return createDmnEditorStore(props.model, new ComputedStateCache(INITIAL_COMPUTED_CACHE)); }, []);
    var storeRef = React.useRef(store);
    var resetState = useCallback(function (_a) {
        var _b;
        var args = _a.args;
        (_b = storeRef.current) === null || _b === void 0 ? void 0 : _b.setState(function (state) {
            state.diagram = defaultStaticState().diagram;
            state.dmn.model = args[0];
        });
    }, []);
    return (_jsx(DmnEditorContextProvider, __assign({}, props, { children: _jsx(ErrorBoundary, __assign({ FallbackComponent: DmnEditorErrorFallback, onReset: resetState }, { children: _jsx(DmnEditorExternalModelsContextProvider, __assign({}, props, { children: _jsx(DmnEditorStoreApiContext.Provider, __assign({ value: storeRef.current }, { children: _jsx(CommandsContextProvider, { children: _jsx(DmnEditorInternal, __assign({ forwardRef: ref }, props)) }) })) })) })) })));
});
export function usePrevious(value) {
    var _a = __read(useState(value), 2), current = _a[0], setCurrent = _a[1];
    var _b = __read(useState(value), 2), previous = _b[0], setPrevious = _b[1];
    if (value !== current) {
        setPrevious(current);
        setCurrent(value);
    }
    return previous;
}
export function useStateAsItWasBeforeConditionBecameTrue(state, condition, set) {
    var previous = usePrevious(state);
    useEffect(function () {
        if (condition) {
            console.debug("HOOK: `useStateBeforeCondition` --> ASSIGN");
            set(previous);
        }
    }, [condition, set]);
}
//# sourceMappingURL=DmnEditor.js.map